/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.xml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRecordReader {
    private final DataFactory _dataFactory;

    public DOMRecordReader() {
        this._dataFactory = DataFactory.DEFAULT;
    }

    public DOMRecordReader(DataFactory dataFactory) {
        this._dataFactory = dataFactory;
    }

    public Record parseRecordIn(Element parentElement) {
        NodeList children = parentElement.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Element recordElement;
                Node childNode = children.item(i);
                if (childNode instanceof Element && "Record".equals((recordElement = (Element)childNode).getLocalName())) {
                    return this.parseRecordFrom(recordElement);
                }
                ++i;
            }
        }
        return null;
    }

    public List<Record> parseRecordsIn(Element parentElement) {
        NodeList children = parentElement.getChildNodes();
        ArrayList<Record> records = new ArrayList<Record>();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Element recordElement;
                Node childNode = children.item(i);
                if (childNode instanceof Element && "Record".equals((recordElement = (Element)childNode).getLocalName())) {
                    records.add(this.parseRecordFrom(recordElement));
                }
                ++i;
            }
        }
        return records;
    }

    public Record parseRecordFrom(Element recordElement) {
        Record record = this._dataFactory.createRecord();
        record.getMetadata().putAll(this.parseMap(recordElement));
        this.parseAttachments(record, recordElement);
        return record;
    }

    public AnyMap parseMap(Element mapElement) {
        AnyMap map = this._dataFactory.createAnyMap();
        NodeList children = mapElement.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (childNode instanceof Element) {
                    Element childElement = (Element)childNode;
                    String childKey = childElement.getAttribute("key");
                    if ("Map".equals(childElement.getLocalName())) {
                        map.put(childKey, this.parseMap(childElement));
                    } else if ("Seq".equals(childElement.getLocalName())) {
                        map.put(childKey, this.parseSeq(childElement));
                    } else if ("Val".equals(childElement.getLocalName())) {
                        map.put(childKey, this.parseValue(childElement));
                    }
                }
                ++i;
            }
        }
        return map;
    }

    public AnySeq parseSeq(Element seqElement) {
        AnySeq seq = this._dataFactory.createAnySeq();
        NodeList children = seqElement.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (childNode instanceof Element) {
                    Element childElement = (Element)childNode;
                    if ("Map".equals(childElement.getLocalName())) {
                        seq.add(this.parseMap(childElement));
                    } else if ("Seq".equals(childElement.getLocalName())) {
                        seq.add(this.parseSeq(childElement));
                    } else if ("Val".equals(childElement.getLocalName())) {
                        seq.add(this.parseValue(childElement));
                    }
                }
                ++i;
            }
        }
        return seq;
    }

    public Value parseValue(Element valueElement) {
        Value value;
        String dataType = valueElement.getAttribute("type");
        String stringValue = valueElement.getTextContent();
        if (dataType != null && !dataType.isEmpty()) {
            try {
                value = this._dataFactory.parseFromString(stringValue, dataType);
            }
            catch (InvalidValueTypeException invalidValueTypeException) {
                value = this._dataFactory.createStringValue(stringValue);
            }
        } else {
            value = this._dataFactory.createStringValue(stringValue);
        }
        return value;
    }

    private void parseAttachments(Record record, Element recordElement) {
        NodeList attachmentElements = recordElement.getElementsByTagNameNS("http://www.eclipse.org/smila/record", "Attachment");
        if (attachmentElements != null && attachmentElements.getLength() > 0) {
            int i = 0;
            while (i < attachmentElements.getLength()) {
                Element attachmentElement = (Element)attachmentElements.item(i);
                String attachmentName = attachmentElement.getTextContent();
                record.setAttachment(attachmentName, null);
                ++i;
            }
        }
    }
}

