/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.pipelets.ATransformationPipelet;
import org.eclipse.smila.processing.pipelets.SourceType;
import org.eclipse.smila.processing.util.ResultCollector;

public class CopyPipelet
extends ATransformationPipelet {
    private static final String PROPERTY_MODE = "mode";
    private final Log _log = LogFactory.getLog(this.getClass());

    protected Mode getMode(ParameterAccessor paramAccessor) throws MissingParameterException {
        String mode = paramAccessor.getParameter(PROPERTY_MODE, null);
        if (mode != null) {
            return Mode.valueOf(mode);
        }
        return Mode.COPY;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._config);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    paramAccessor.setCurrentRecord(id);
                    SourceType inputType = this.getInputType(paramAccessor);
                    SourceType outputType = this.getOutputType(paramAccessor);
                    String inputName = this.getInputName(paramAccessor);
                    String outputName = this.getOutputName(paramAccessor);
                    String srcValue = this.readStringInput(blackboard, id, paramAccessor);
                    if (srcValue != null) {
                        this.storeResult(blackboard, id, srcValue, paramAccessor);
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("copied value from input " + (Object)((Object)inputType) + " " + inputName + " to " + (Object)((Object)outputType) + " " + outputName));
                        }
                    }
                    if (Mode.MOVE.equals((Object)this.getMode(paramAccessor))) {
                        if (this.isReadFromAttribute(inputType)) {
                            AnyMap metaData = blackboard.getMetadata(id);
                            metaData.remove((Object)inputName);
                        } else {
                            blackboard.removeAttachment(id, inputName);
                        }
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("deleted value of input " + (Object)((Object)inputType) + " " + inputName));
                        }
                    }
                    resultCollector.addResult(id);
                }
                catch (Exception ex) {
                    resultCollector.addFailedResult(id, ex);
                }
                ++n2;
            }
        }
        return resultCollector.getResultIds();
    }

    private static enum Mode {
        COPY,
        MOVE;

    }
}

