/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.recordstorage.util;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.recordstorage.util.RecordDao;

public class RecordIterator
implements Iterator<Record> {
    private final Iterator<RecordDao> _daoIterator;

    public RecordIterator(Iterator<RecordDao> daoIterator) {
        if (daoIterator == null) {
            throw new IllegalArgumentException("parameter daoIterator is null");
        }
        this._daoIterator = daoIterator;
    }

    @Override
    public boolean hasNext() {
        return this._daoIterator.hasNext();
    }

    @Override
    public Record next() {
        RecordDao dao = this._daoIterator.next();
        if (dao != null) {
            try {
                return dao.toRecord();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public void remove() {
        this._daoIterator.remove();
    }
}

