/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.bulkbuilder;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.BulkbuilderService;
import org.eclipse.smila.bulkbuilder.WorkflowRunInfo;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.ConnectivityManager;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.JobState;
import org.eclipse.smila.utils.MaybeRecoverableException;

public class ConnectivityManagerImpl
implements ConnectivityManager {
    private final Log _log = LogFactory.getLog(ConnectivityManagerImpl.class);
    private BulkbuilderService _bulkbuilder;
    private JobManager _jobManager;

    public ConnectivityManagerImpl() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Creating ConnectivityManagerImpl");
        }
    }

    public void checkJobIsActive(String jobName) throws ConnectivityException {
        JobRunInfo info;
        try {
            info = this._jobManager.getJobRunInfo(jobName);
        }
        catch (Exception ex) {
            throw new ConnectivityException("Cannot check state of job '" + jobName + "'", (Throwable)ex);
        }
        if (info == null || info.getState() != JobState.RUNNING) {
            throw new ConnectivityException("Job '" + jobName + "' is not defined or not active, create and start it before trying to submit records.", false);
        }
    }

    public int add(Record[] records, String jobName) throws ConnectivityException {
        HashMap<String, MaybeRecoverableException> exceptionMap = new HashMap<String, MaybeRecoverableException>();
        String microBulkId = UUID.randomUUID().toString();
        Record[] recordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            Record record = recordArray[n2];
            try {
                this._bulkbuilder.addToMicroBulk(jobName, record, microBulkId);
            }
            catch (MaybeRecoverableException e) {
                String msg = "Error while adding record with id '" + record.getId() + "' to bulkbuilder";
                if (e.isRecoverable()) {
                    this._log.warn((Object)msg, (Throwable)e);
                    exceptionMap.put(record.getId(), e);
                }
                throw new ConnectivityException(msg, (Throwable)e, false);
            }
            catch (Exception e) {
                throw new ConnectivityException((Throwable)e, false);
            }
            try {
                this._bulkbuilder.finishMicroBulk(jobName, microBulkId);
            }
            catch (BulkbuilderException e) {
                String message = "Error while adding " + records.length + " records to bulkbuilder";
                this._log.error((Object)message, (Throwable)e);
                throw new ConnectivityException(message, (Throwable)e);
            }
            ++n2;
        }
        if (!exceptionMap.isEmpty()) {
            this._log.warn((Object)("Added " + (records.length - exceptionMap.size()) + " of " + records.length + " records. Exceptions occured: " + exceptionMap));
        }
        return records.length - exceptionMap.size();
    }

    public int delete(Record[] records, String jobName) throws ConnectivityException {
        HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
        WorkflowRunInfo info = null;
        Record[] recordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            Record record = recordArray[n2];
            try {
                info = this._bulkbuilder.deleteRecord(jobName, record);
            }
            catch (BulkbuilderException e) {
                String msg = "Error while deleting record with id '" + record.getId() + "' to bulkbuilder";
                if (e.isRecoverable()) {
                    this._log.warn((Object)msg, (Throwable)e);
                    exceptionMap.put(record.getId(), e);
                }
                throw new ConnectivityException(msg, (Throwable)e, false);
            }
            catch (Exception e) {
                this._log.warn((Object)("Error while deleting record with id '" + record.getId() + "'"), (Throwable)e);
                exceptionMap.put(record.getId(), e);
            }
            ++n2;
        }
        if (!exceptionMap.isEmpty()) {
            this._log.warn((Object)("Deleted " + (records.length - exceptionMap.size()) + " of " + records.length + " records. Exceptions occured: " + exceptionMap));
        } else if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Deleted " + records.length + " records for job run " + info.getJobId()));
        }
        return records.length - exceptionMap.size();
    }

    public void setBulkbuilderService(BulkbuilderService service) {
        this._bulkbuilder = service;
    }

    public void unsetBulkbuilderService(BulkbuilderService service) {
        if (this._bulkbuilder == service) {
            this._bulkbuilder = null;
        }
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

