/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.helpers;

import org.eclipse.smila.management.jmx.client.config.CmdConfigType;
import org.eclipse.smila.management.jmx.client.config.ConnectionConfigType;
import org.eclipse.smila.management.jmx.client.config.JmxClientConfigType;
import org.eclipse.smila.management.jmx.client.config.SampleConfigType;
import org.eclipse.smila.management.jmx.client.helpers.ConsoleArguments;

public final class ConfigHelper {
    private ConfigHelper() {
    }

    public static ConnectionConfigType findConnectionConfig(ConsoleArguments arguments, JmxClientConfigType config) {
        ConnectionConfigType connectionConfig = null;
        if (arguments.getConnection() == null) {
            connectionConfig = config.getConnection().get(0);
        } else {
            for (ConnectionConfigType iConnectionConfig : config.getConnection()) {
                if (!arguments.getConnection().equals(iConnectionConfig.getId())) continue;
                connectionConfig = iConnectionConfig;
                break;
            }
        }
        if (connectionConfig == null) {
            throw new IllegalArgumentException(String.format("Unable to find connection with id=[%s]", arguments.getConnection()));
        }
        return connectionConfig;
    }

    public static CmdConfigType findCmdConfig(ConsoleArguments arguments, JmxClientConfigType config) {
        CmdConfigType cmdConfig = null;
        if (arguments.getCmd() == null) {
            throw new IllegalArgumentException("Operation argument cannot be null");
        }
        for (CmdConfigType iCmdConfig : config.getCmd()) {
            if (!arguments.getCmd().equals(iCmdConfig.getId())) continue;
            cmdConfig = iCmdConfig;
            break;
        }
        if (cmdConfig == null) {
            throw new IllegalArgumentException(String.format("Unable to find command with id=[%s]", arguments.getCmd()));
        }
        return cmdConfig;
    }

    public static String createHelpString(JmxClientConfigType config, String commandName) {
        StringBuilder builder = new StringBuilder("<Connections> - optional\n");
        boolean first = true;
        for (ConnectionConfigType connectionConfig : config.getConnection()) {
            builder.append(String.format("  %-20s\t%s:%s", connectionConfig.getId(), connectionConfig.getHost(), connectionConfig.getPort()));
            if (first) {
                builder.append("  - default\n");
                first = false;
                continue;
            }
            builder.append("\n");
        }
        builder.append("\n<Operations>  - required\n");
        for (CmdConfigType cmdConfig : config.getCmd()) {
            builder.append(String.format("  %-20s\t%s\n", cmdConfig.getId(), cmdConfig.getEcho()));
        }
        if (!config.getSample().isEmpty()) {
            builder.append("\nSamples:\n");
            for (SampleConfigType sampleConfigType : config.getSample()) {
                builder.append("  ").append(commandName);
                builder.append(" ").append(sampleConfigType.getValue()).append("\n");
                builder.append("            ").append(sampleConfigType.getEcho()).append("\n");
            }
        }
        return builder.toString();
    }
}

