/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.worker;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.worker.ProcessingWorker;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.TaskLog;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class PipeletProcessorWorker
extends ProcessingWorker {
    public static final String WORKER_NAME = "pipeletProcessor";
    public static final String KEY_PIPELET_NAME = "pipeletName";
    private PipeletTracker _pipeletTracker;

    public String getName() {
        return WORKER_NAME;
    }

    @Override
    public boolean perform(AnyMap parameters, RecordInput recordInput, RecordOutput recordOutput, TaskContext taskContext) throws Exception {
        Pipelet pipelet = this.createPipeletInstance(parameters);
        Record record = null;
        boolean success = false;
        do {
            if ((record = recordInput.getRecord()) == null || taskContext.isCanceled()) continue;
            Blackboard blackboard = this.getBlackboard();
            blackboard.setRecord(record);
            success |= this.processRecord(blackboard, record.getId(), pipelet, recordOutput, taskContext.getLog());
        } while (record != null && !taskContext.isCanceled());
        return success;
    }

    private Pipelet createPipeletInstance(AnyMap parameters) throws ProcessingException, InstantiationException, IllegalAccessException {
        String pipeletName = this.getPipeletName(parameters);
        Class pipeletClass = (Class)this._pipeletTracker.getRegisteredPipelets().get(pipeletName);
        if (pipeletClass == null) {
            throw new ProcessingException("Pipelet '" + pipeletClass + "' is not available currently.", false);
        }
        Pipelet pipelet = (Pipelet)pipeletClass.newInstance();
        pipelet.configure(parameters);
        return pipelet;
    }

    private boolean processRecord(Blackboard blackboard, String recordId, Pipelet pipelet, RecordOutput recordOutput, TaskLog taskLog) throws Exception {
        try {
            String[] resultIds = pipelet.process(blackboard, new String[]{recordId});
            this.writeResultRecords(blackboard, resultIds, recordOutput, taskLog);
            return true;
        }
        catch (ProcessingException ex) {
            if (ex.isRecoverable()) {
                throw ex;
            }
            taskLog.warn("Failed to process record " + recordId + ", skipping it.", (Throwable)ex);
            return false;
        }
    }

    private String getPipeletName(AnyMap parameters) {
        String pipeletName = parameters.getStringValue(KEY_PIPELET_NAME);
        if (pipeletName == null || pipeletName.isEmpty()) {
            throw new IllegalArgumentException("Pipeline name parameter pipeletName is not set.");
        }
        if (this._pipeletTracker.getRegisteredPipelets().get(pipeletName) == null) {
            throw new IllegalArgumentException("Configured pipelet " + pipeletName + " doesn't exist.");
        }
        return pipeletName;
    }

    public void setPipeletTracker(PipeletTracker pipeletTracker) {
        this._pipeletTracker = pipeletTracker;
    }

    public void unsetPipeletTracker(PipeletTracker pipeletTracker) {
        if (this._pipeletTracker == pipeletTracker) {
            this._pipeletTracker = null;
        }
    }
}

