/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.worker;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.TaskLog;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;

public abstract class ProcessingWorker
implements Worker {
    public static final String INPUT_SLOT_NAME = "input";
    public static final String OUTPUT_SLOT_NAME = "output";
    protected static boolean s_noBinStorageAvailableLogged;
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected BlackboardFactory _blackboardFactory;
    protected boolean _tryToUseBinStorage = true;

    public void perform(TaskContext taskContext) throws Exception {
        AnyMap parameters = this.getTaskParameters(taskContext);
        RecordInput recordInput = taskContext.getInputs().getAsRecordInput(INPUT_SLOT_NAME);
        RecordOutput recordOutput = taskContext.getOutputs().getAsRecordOutput(OUTPUT_SLOT_NAME);
        this._tryToUseBinStorage = true;
        boolean success = this.perform(parameters, recordInput, recordOutput, taskContext);
        if (!success) {
            throw new ProcessingException("None of the records of task " + taskContext.getTask() + " could be successfully processed, have a look at the log for details.");
        }
    }

    public abstract boolean perform(AnyMap var1, RecordInput var2, RecordOutput var3, TaskContext var4) throws Exception;

    private AnyMap getTaskParameters(TaskContext taskContext) {
        AnyMap parameterMap = DataFactory.DEFAULT.cloneAnyMap(taskContext.getTask().getParameters());
        if (parameterMap.get((Object)"_failOnError") == null) {
            parameterMap.put("_failOnError", "false");
        }
        return parameterMap;
    }

    protected void writeResultRecords(Blackboard blackboard, String[] resultIds, RecordOutput recordOutput, TaskLog taskLog) throws ObjectStoreException, IOException {
        block6: {
            try {
                if (resultIds == null || recordOutput == null) break block6;
                String[] stringArray = resultIds;
                int n = resultIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String resultId = stringArray[n2];
                    try {
                        recordOutput.writeRecord(blackboard.getRecord(resultId));
                    }
                    catch (BlackboardAccessException ex) {
                        taskLog.warn("Failed to read result record " + resultId + " from blackboard, skipping it.", (Throwable)ex);
                    }
                    ++n2;
                }
            }
            finally {
                blackboard.unload();
            }
        }
    }

    protected Blackboard getBlackboard() throws Exception {
        Blackboard blackboard;
        try {
            blackboard = this._blackboardFactory.createBlackboard(false, this._tryToUseBinStorage);
        }
        catch (BlackboardAccessException blackboardAccessException) {
            this._tryToUseBinStorage = false;
            if (!s_noBinStorageAvailableLogged) {
                this._log.warn((Object)"Could not get a blackboard with binary storage, using a transient one. Attachments won't be accessible by the worker.");
                s_noBinStorageAvailableLogged = true;
            }
            blackboard = this._blackboardFactory.createTransientBlackboard();
        }
        return blackboard;
    }

    public void setBlackboardFactory(BlackboardFactory factory) {
        this._blackboardFactory = factory;
    }

    public void unsetBlackboardFactory(BlackboardFactory factory) {
        if (this._blackboardFactory == factory) {
            this._blackboardFactory = null;
        }
    }
}

