/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.conversion;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;

public final class DefaultConversionUtils {
    private static final ConvertUtilsBean CUB = new ConvertUtilsBean();
    private static final String FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String FORMAT_DATETIME2 = "yyyy-MM-dd HH:mm:ss";
    private static final String FORMAT_DATETIME3 = "yyyy-MM-dd HH:mm";
    private static final String FORMAT_DATETIME4 = "yyyy-MM-dd";

    static {
        CUB.deregister(String.class);
        CUB.register((Converter)new StringConverter(), String.class);
        CUB.deregister(Date.class);
        CUB.register((Converter)new DateConverter(), Date.class);
    }

    private DefaultConversionUtils() {
    }

    public static Object convert(String source, Class clazz) {
        return CUB.convert(source, clazz);
    }

    public static String convert(Object value) {
        return CUB.convert(value);
    }

    private static class DateConverter
    implements Converter {
        private DateConverter() {
        }

        public Object convert(Class class1, Object obj) {
            if (obj == null) {
                return null;
            }
            String v = obj.toString();
            try {
                return new SimpleDateFormat(DefaultConversionUtils.FORMAT_DATETIME).parse(v);
            }
            catch (Throwable throwable) {
                try {
                    return new SimpleDateFormat(DefaultConversionUtils.FORMAT_DATETIME2).parse(v);
                }
                catch (Throwable throwable2) {
                    try {
                        return new SimpleDateFormat(DefaultConversionUtils.FORMAT_DATETIME3).parse(v);
                    }
                    catch (Throwable throwable3) {
                        try {
                            return new SimpleDateFormat(DefaultConversionUtils.FORMAT_DATETIME4).parse(v);
                        }
                        catch (Throwable throwable4) {
                            throw new ConversionException("Unable to parse date " + v);
                        }
                    }
                }
            }
        }
    }

    private static class StringConverter
    implements Converter {
        private StringConverter() {
        }

        public Object convert(Class class1, Object obj) {
            if (obj == null) {
                return null;
            }
            if (Date.class.isAssignableFrom(obj.getClass())) {
                return new SimpleDateFormat(DefaultConversionUtils.FORMAT_DATETIME).format(obj);
            }
            return obj.toString();
        }
    }
}

