/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.scriptexecution;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.utils.scriptexecution.LogHelper;
import org.eclipse.smila.utils.scriptexecution.ScriptExecutor;

public class UnixScriptExecutor
implements ScriptExecutor {
    private static final String SHELL_ENV_NAME = "SHELL";
    private final Log _log = LogFactory.getLog(UnixScriptExecutor.class);

    @Override
    public int execute(File file) throws IOException, InterruptedException {
        int n;
        String shell = System.getenv(SHELL_ENV_NAME);
        if (shell == null || shell.trim().length() == 0) {
            throw new RuntimeException("Environment variable 'SHELL' is not set");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(shell);
        processBuilder.directory(file.getParentFile());
        processBuilder.redirectErrorStream(true);
        Process shellProcess = processBuilder.start();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            OutputStream shellProcessOutputStream = shellProcess.getOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)shellProcessOutputStream);
            shellProcessOutputStream.close();
            int retVal = shellProcess.waitFor();
            LogHelper.debug(this._log, shellProcess.getInputStream());
            n = retVal;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return n;
    }
}

