/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.performancecounters;

import java.lang.reflect.Constructor;

import org.eclipse.smila.connectivity.framework.AgentController;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementAgentNotFoundException;
import org.eclipse.smila.management.ManagementRegistration;

/**
 * The Class CrawlerPerformanceCounterHelper.
 * 
 * @param <AgentType>
 *          real agent class
 */
public class AgentPerformanceCounterHelper<AgentType extends ConnectivityPerformanceAgent> extends
  ConnectivityPerformanceCounterHelperBase<AgentType> {

  /**
   * Instantiates a new crawler performance counter helper.
   * 
   * @param configuration
   *          the configuration
   * @param hashCode
   *          the hash code
   * @param agentClass
   *          the agent class
   */
  public AgentPerformanceCounterHelper(final DataSourceConnectionConfig configuration, final int hashCode,
    final Class<AgentType> agentClass) {
    super(configuration, hashCode, agentClass);
  }

  /** {@inheritDoc} */
  @Override
  protected String getPerformanceAgentLocation() {
    return AgentController.PERFORMANCE_AGENT_LOCATION;
  }

  /** {@inheritDoc} */
  @Override
  protected String getPerformanceAgentCategory() {
    return "Agents";
  }

  /** {@inheritDoc} */
  @Override
  protected String getdateConnectionIdSuffix() {
    return "Agent";
  }

  /**
   * Inits the agent.
   * 
   * @param location
   *          the location
   * 
   * @return the agent type
   */
  @Override
  @SuppressWarnings("unchecked")
  protected AgentType initAgent(final ManagementAgentLocation location) {
    synchronized (ManagementRegistration.INSTANCE.getMonitor()) {
      try {
        return (AgentType) ManagementRegistration.INSTANCE.getAgent(location);
      } catch (final ManagementAgentNotFoundException e) {
        // register new
        try {
          final Constructor<AgentType> constructor = _agentClass.getConstructor();
          final AgentType agent = constructor.newInstance();
          ManagementRegistration.INSTANCE.registerAgent(location, agent);
          return agent;
        } catch (final Throwable e1) {
          throw new RuntimeException(e1);
        }
      }
    }
  }

}
