/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Peter Wissel (brox IT Solutions GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.solr.admin;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.CoreAdminParams.CoreAdminAction;
import org.eclipse.smila.solr.util.SolrHelper;

/**
 * The SolrBaseAdmin class.
 * 
 * @author pwissel
 * 
 */
public abstract class SolrBaseAdmin implements SolrAdmin {

  /**
   * The log.
   */
  protected final Log _log = LogFactory.getLog(SolrAdmin.class);

  /**
   * The solr helper.
   */
  protected final SolrHelper _helper;

  /**
   * Constructor.
   * 
   * @param helper
   *          the SolrHelper.
   */
  public SolrBaseAdmin(SolrHelper helper) {
    _helper = helper;
  }

  /**
   * Build the Solr parameter map.
   * 
   * @param action
   *          the action to perform.
   * @param core
   *          the core name or null.
   * @param other
   *          the other core name or null.
   * @return
   */
  protected Map<String, String[]> buildAdminParams(final CoreAdminAction action, final String core,
    final String other) {
    final Map<String, String[]> params = new HashMap<String, String[]>();
    final String[] actionParam = { action.toString() };
    params.put(CoreAdminParams.ACTION, actionParam);
    if (StringUtils.isNotBlank(core)) {
      final String[] coreParam = { core };
      params.put(CoreAdminParams.CORE, coreParam);
    }
    if (StringUtils.isNotBlank(other)) {
      final String[] otherCoreParam = { other };
      params.put(CoreAdminParams.OTHER, otherCoreParam);
    }
    return params;
  }

}
