/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky (empolis GmbH) - initial API and implementation
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity;

import org.eclipse.smila.datamodel.Record;

/**
 * The Interface ConnectivityManager.
 */
public interface ConnectivityManager {

  /**
   * Record attribute '_importRunId'.
   */
  String ATTRIBUTE_IMPORT_RUN_ID = "_importRunId";

  /**
   * check if records can be added or deleted using this job name.
   * 
   * @param jobName
   *          name of job to check.
   * @throws ConnectivityException
   *           if job is not active currently, message and cause may contain further details.
   */
  void checkJobIsActive(String jobName) throws ConnectivityException;

  /**
   * Push the given records to the given job.
   * 
   * @param records
   *          a list of Record objects
   * @param jobName
   *          name of the jobs for which to push the records.
   * 
   * @return the number of records successfully added.
   * 
   * @throws ConnectivityException
   *           if any error occurs
   */
  int add(Record[] records, String jobName) throws ConnectivityException;

  /**
   * Delete the given records for the given job.
   * 
   * @param records
   *          a list of records to delete
   * 
   * @return the number of records successfully deleted.
   * 
   * @throws ConnectivityException
   *           if any error occurs
   */
  int delete(Record[] records, String jobName) throws ConnectivityException;
}
