/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager;

/**
 * Illegal call on JobManager for current job state.
 */
public class IllegalJobStateException extends JobManagerException {

  /** is serializable. */
  private static final long serialVersionUID = 1L;

  /** job-run-is-gone flag. */
  private final boolean _jobRunGone;

  /**
   * create exception with description and gone flag set to false.
   */
  public IllegalJobStateException(final String message) {
    this(message, false);
  }

  /**
   * create exception with description and custom gone flag.
   */
  public IllegalJobStateException(final String message, final boolean gone) {
    super(message, false);
    _jobRunGone = gone;
  }

  /** @return gone flag. */
  public boolean isJobRunGone() {
    return _jobRunGone;
  }
}
