/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.util;

import java.util.UUID;

/**
 * Utility class for creating ids needed in jobmanager.
 */
public final class IdGenerator {

  /**
   * Private constructor to avoid instance creation.
   */
  private IdGenerator() {
  }

  /**
   * Creates an unique id.
   * 
   * @return unique id
   */
  public static String createTaskId() {
    return UUID.randomUUID().toString();
  }

  /**
   * Creates an unique id for bulks.
   * 
   * @return unique id
   */
  public static String createBulkId() {
    return UUID.randomUUID().toString();
  }
}
