/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.objectstore;

/**
 * Thrown to describe that some possibly temporary condition prevents the {@link ObjectStoreService} from performing an
 * operation (e.g. network failures, if the service implementation depends on talking It may make sense for a client to
 * retry the operation after a short time, but there is no guarantee that it will succeed then. The service
 * implementation may use further subclasses or the {@link #getCause()} of this exception to describe the error in more
 * details.
 */
public class ServiceUnavailableException extends ObjectStoreException {
  /** because it's serializable ... */
  private static final long serialVersionUID = 1L;

  /** create exception with description and causing exception. */
  public ServiceUnavailableException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** create exception with description only. */
  public ServiceUnavailableException(final String message) {
    super(message);
  }

  /** create exception from causing exception. */
  public ServiceUnavailableException(final Throwable cause) {
    super(cause);
  }

}
