/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.DefinitionBase;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.internal.AccessAny;

public class JobDefinition
extends DefinitionBase {
    public static final String KEY_JOBS = "jobs";
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_WORKFLOW = "workflow";
    private final AnyMap _parameters;
    private final String _workflow;

    public JobDefinition(AnyMap job) throws InvalidConfigException {
        super(job);
        this._workflow = AccessAny.getStringRequired(job, KEY_WORKFLOW);
        Any parametersAny = (Any)job.get((Object)KEY_PARAMETERS);
        if (parametersAny == null) {
            this._parameters = null;
        } else {
            if (!parametersAny.isMap()) {
                throw new InvalidConfigException("Error reading jobs record object. Field parameter is not of type MAP.");
            }
            try {
                this._parameters = (AnyMap)parametersAny;
            }
            catch (Exception e) {
                throw new InvalidConfigException("Error reading parameters for jobs record object.", e);
            }
        }
    }

    public static JobDefinition parseJob(AnyMap jobAny) throws InvalidConfigException {
        JobDefinition job = null;
        try {
            job = new JobDefinition(jobAny);
        }
        catch (InvalidConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidConfigException("Invalid any structure", ex);
        }
        return job;
    }

    public AnyMap getParameters() {
        return this._parameters;
    }

    public String getWorkflow() {
        return this._workflow;
    }

    @Override
    public AnyMap toAny(boolean includingAdditionalAttributes) {
        try {
            AnyMap jobAny = super.toAny(includingAdditionalAttributes);
            if (!includingAdditionalAttributes) {
                if (this._parameters != null) {
                    jobAny.put(KEY_PARAMETERS, (Any)this._parameters);
                }
                jobAny.put(KEY_WORKFLOW, this._workflow);
            }
            return jobAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for job " + this._name, ex);
        }
    }
}

