/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.jobmanager.BucketDefinition;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.persistence.DefinitionPersistence;
import org.eclipse.smila.processing.ProcessingException;
import org.osgi.service.component.ComponentContext;

public class BucketsHandler
extends JsonRequestHandler {
    private JobManager _jobManager;
    private DefinitionPersistence _defPersistence;

    protected void activate(ComponentContext context) {
        super.activate(context);
        this._defPersistence = this._jobManager.getDefinitionPersistence();
    }

    protected void deactivate(ComponentContext context) {
        this._defPersistence = null;
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        if ("GET".equals(method)) {
            HashMap resultMap = new HashMap();
            ArrayList bucketList = new ArrayList();
            for (String bucketName : this._defPersistence.getBuckets()) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("name", bucketName);
                map.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)bucketName));
                bucketList.add(map);
            }
            resultMap.put("buckets", bucketList);
            return resultMap;
        }
        if (inputRecord == null) {
            throw new ProcessingException("Missing input, cannot create buckets from nothing.");
        }
        AnyMap definition = inputRecord.getMetadata();
        Value timestamp = inputRecord.getFactory().createDateTimeValue(new Date());
        definition.put("timestamp", (Any)timestamp);
        definition.remove((Object)"readOnly");
        BucketDefinition createdBucket = BucketDefinition.parseBucket(definition);
        this._defPersistence.addBucket(createdBucket);
        AnyMap result = DataFactory.DEFAULT.createAnyMap();
        result.put("name", createdBucket.getName());
        result.put("timestamp", (Any)timestamp);
        result.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)createdBucket.getName()).toExternalForm());
        return result;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof InvalidConfigException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected int getSuccessStatus(String method, String requestUri) {
        if ("POST".equals(method)) {
            return 201;
        }
        return super.getSuccessStatus(method, requestUri);
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "POST".equals(method);
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

