/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.Date;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.jobmanager.InvalidConfigException;
import org.eclipse.smila.jobmanager.JobManager;
import org.eclipse.smila.jobmanager.WorkflowDefinition;
import org.eclipse.smila.jobmanager.persistence.DefinitionPersistence;
import org.eclipse.smila.jobmanager.persistence.PersistenceException;
import org.eclipse.smila.utils.http.NotFoundHTTPResult;
import org.osgi.service.component.ComponentContext;

public class WorkflowsHandler
extends JsonRequestHandler {
    private JobManager _jobManager;
    private DefinitionPersistence _defPersistence;

    protected void activate(ComponentContext context) {
        super.activate(context);
        this._defPersistence = this._jobManager.getDefinitionPersistence();
    }

    protected void deactivate(ComponentContext context) {
        this._defPersistence = null;
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        AnyMap resultMap = DataFactory.DEFAULT.createAnyMap();
        if ("GET".equals(method)) {
            AnySeq workflowList = DataFactory.DEFAULT.createAnySeq();
            boolean returnDetails = false;
            if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)"returnDetails")) {
                returnDetails = inputRecord.getMetadata().getBooleanValue("returnDetails");
            }
            for (String workflowName : this._defPersistence.getWorkflows()) {
                AnyMap map = DataFactory.DEFAULT.createAnyMap();
                map.put("name", workflowName);
                map.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)workflowName).toExternalForm());
                if (returnDetails && this._defPersistence.getWorkflow(workflowName).getTimestamp() != null) {
                    map.put("timestamp", (Any)DataFactory.DEFAULT.createDateTimeValue(this._defPersistence.getWorkflow(workflowName).getTimestamp()));
                }
                workflowList.add((Object)map);
            }
            resultMap.put("workflows", (Any)workflowList);
        } else {
            if (inputRecord == null) {
                throw new IllegalArgumentException("Missing input, cannot create workflows from nothing.");
            }
            AnyMap definition = inputRecord.getMetadata();
            Value timestamp = inputRecord.getFactory().createDateTimeValue(new Date());
            definition.put("timestamp", (Any)timestamp);
            definition.remove((Object)"readOnly");
            WorkflowDefinition createdWorkflow = WorkflowDefinition.parseWorkflow(definition);
            this._defPersistence.addWorkflow(createdWorkflow);
            resultMap.put("name", createdWorkflow.getName());
            resultMap.put("timestamp", (Any)timestamp);
            resultMap.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)createdWorkflow.getName()).toExternalForm());
        }
        return resultMap;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof NotFoundHTTPResult) {
            return 404;
        }
        if (ex instanceof PersistenceException) {
            return 500;
        }
        if (ex instanceof InvalidConfigException || ex instanceof IllegalArgumentException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected int getSuccessStatus(String method, String requestUri) {
        if ("POST".equals(method)) {
            return 201;
        }
        return super.getSuccessStatus(method, requestUri);
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "POST".equals(method);
    }

    public void setJobManager(JobManager jobManager) {
        this._jobManager = jobManager;
    }

    public void unsetJobManager(JobManager jobManager) {
        if (this._jobManager == jobManager) {
            this._jobManager = null;
        }
    }
}

