/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.Bucket;
import org.eclipse.smila.jobmanager.BucketDefinition;
import org.eclipse.smila.jobmanager.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.JobDefinition;
import org.eclipse.smila.jobmanager.JobManagerException;
import org.eclipse.smila.jobmanager.WorkerDefinition;
import org.eclipse.smila.jobmanager.WorkflowAction;
import org.eclipse.smila.jobmanager.WorkflowDefinition;
import org.eclipse.smila.jobmanager.persistence.DefinitionPersistence;
import org.eclipse.smila.jobmanager.persistence.PersistenceException;
import org.eclipse.smila.jobmanager.persistence.RunStorage;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorProvider;
import org.eclipse.smila.jobmanager.util.ExpressionUtil;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.utils.collections.MultiValueMap;

public class JobRun {
    private static final long MIN_TASK_GENERATION_TIME_TO_LOG = 1000L;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final String _jobRunId;
    private final JobDefinition _jobDef;
    private final WorkflowDefinition _workflowDef;
    private WorkflowAction _startAction;
    private final MultiValueMap<String, WorkflowAction> _bucketToTriggeredAction = new MultiValueMap();
    private final Map<String, Bucket> _buckets = new HashMap<String, Bucket>();
    private final Map<WorkflowAction, Map<String, Bucket>> _actionInputBuckets = new HashMap<WorkflowAction, Map<String, Bucket>>();
    private final Map<WorkflowAction, Map<String, Bucket>> _actionOutputBuckets = new HashMap<WorkflowAction, Map<String, Bucket>>();
    private final Map<String, WorkerDefinition> _workers = new HashMap<String, WorkerDefinition>();
    private final AnyMap _parameters = DataFactory.DEFAULT.createAnyMap();
    private final Map<String, BucketDefinition> _bucketDefinitions = new HashMap<String, BucketDefinition>();
    private final TaskGeneratorProvider _taskGeneratorProvider;

    public JobRun(String runId, String jobName, RunStorage runStorage, DefinitionPersistence definitions, TaskGeneratorProvider taskGeneratorProvider) throws Exception {
        AnyMap jobRunData = runStorage.getJobRunData(jobName, true);
        AnyMap jobDefinitionMap = jobRunData.getMap("jobDefinition");
        AnyMap workflowDefinitionMap = jobRunData.getMap("workflowDefinition");
        AnySeq bucketsSeq = jobRunData.getSeq("bucketDefinitions");
        if (bucketsSeq != null && bucketsSeq.size() > 0) {
            for (AnyMap bucketsAny : bucketsSeq) {
                this._bucketDefinitions.put(bucketsAny.getStringValue("name"), new BucketDefinition(bucketsAny));
            }
        }
        this._taskGeneratorProvider = taskGeneratorProvider;
        this._jobRunId = runId;
        this._jobDef = new JobDefinition(jobDefinitionMap);
        this._workflowDef = new WorkflowDefinition(workflowDefinitionMap);
        this.compileWorkflow(definitions);
    }

    private void compileWorkflow(DefinitionPersistence definitions) throws PersistenceException {
        if (this._jobDef.getParameters() != null) {
            this._parameters.putAll((Map)this._jobDef.getParameters());
        }
        if (this._workflowDef.getParameters() != null) {
            this._parameters.putAll((Map)this._workflowDef.getParameters());
        }
        this._startAction = this._workflowDef.getStartAction();
        this.compileWorkflowAction(this._startAction, definitions);
        if (this._workflowDef.getActions() != null) {
            for (WorkflowAction action : this._workflowDef.getActions()) {
                this.compileWorkflowAction(action, definitions);
            }
        }
    }

    private void compileWorkflowAction(WorkflowAction action, DefinitionPersistence definitions) throws PersistenceException {
        String workerName = action.getWorker();
        WorkerDefinition workerDef = this.getWorkerDefinition(definitions, workerName);
        this._actionInputBuckets.put(action, new HashMap());
        this._actionOutputBuckets.put(action, new HashMap());
        Map<String, String> actionInputSlotsDefinition = action.getInput();
        Collection<WorkerDefinition.Input> workerInputSlots = workerDef.getInput();
        this.compileActionSlotConfigurations(action, definitions, actionInputSlotsDefinition, workerInputSlots, true);
        if (actionInputSlotsDefinition != null) {
            for (String bucketName : actionInputSlotsDefinition.values()) {
                this._bucketToTriggeredAction.add((Object)bucketName, (Object)action);
            }
        }
        Map<String, String> actionOutputSlotsDefinition = action.getOutput();
        Collection<WorkerDefinition.Output> workerOutputSlots = workerDef.getOutput();
        this.compileActionSlotConfigurations(action, definitions, actionOutputSlotsDefinition, workerOutputSlots, false);
    }

    private void compileActionSlotConfigurations(WorkflowAction action, DefinitionPersistence definitions, Map<String, String> actionSlots, Collection<? extends WorkerDefinition.InputOutput<?>> workerSlots, boolean isInputSlots) throws PersistenceException {
        if (actionSlots != null) {
            for (Map.Entry<String, String> slot : actionSlots.entrySet()) {
                String slotName = slot.getKey();
                String bucketName = slot.getValue();
                Bucket bucket = this._buckets.get(bucketName);
                if (bucket == null) {
                    BucketDefinition bucketDef = this._bucketDefinitions.get(bucketName);
                    boolean isPersistent = true;
                    if (bucketDef == null) {
                        String slotDataObjectType = this.getSlotType(slotName, workerSlots);
                        isPersistent = false;
                        bucketDef = new BucketDefinition(bucketName, slotDataObjectType);
                    }
                    DataObjectTypeDefinition dot = definitions.getDataObjectType(bucketDef.getDataObjectType());
                    bucket = new Bucket(bucketDef, dot, isPersistent, this._parameters);
                    this._buckets.put(bucketName, bucket);
                }
                if (isInputSlots) {
                    this._actionInputBuckets.get(action).put(slotName, bucket);
                    continue;
                }
                this._actionOutputBuckets.get(action).put(slotName, bucket);
            }
        }
    }

    private String getSlotType(String slotName, Collection<? extends WorkerDefinition.InputOutput<?>> slots) {
        if (slots != null) {
            for (WorkerDefinition.InputOutput<?> iterableElement : slots) {
                if (!iterableElement.getName().equals(slotName)) continue;
                return iterableElement.getType();
            }
        }
        return null;
    }

    private WorkerDefinition getWorkerDefinition(DefinitionPersistence definitions, String workerName) throws PersistenceException {
        WorkerDefinition workerDef = this._workers.get(workerName);
        if (workerDef == null) {
            workerDef = definitions.getWorker(workerName);
            this._workers.put(workerName, workerDef);
        }
        return workerDef;
    }

    public WorkerDefinition getWorkerDefinition(String workerName) {
        return this._workers.get(workerName);
    }

    public String getJobName() {
        return this._jobDef.getName();
    }

    public String getJobRunId() {
        return this._jobRunId;
    }

    public JobDefinition getJobDefinition() {
        return this._jobDef;
    }

    public WorkflowDefinition getWorkflowDefinition() {
        return this._workflowDef;
    }

    public Collection<Bucket> getBuckets() {
        return Collections.unmodifiableCollection(this._buckets.values());
    }

    public Bucket getBucket(String bucketName) {
        return this._buckets.get(bucketName);
    }

    public Bucket getBucketForInputSlot(WorkflowAction action, String slotName) {
        return this._actionInputBuckets.get(action).get(slotName);
    }

    public Bucket getBucketForOutputSlot(WorkflowAction action, String slotName) {
        return this._actionOutputBuckets.get(action).get(slotName);
    }

    public Task getInitialTask(String workerName, String workflowRunId) throws JobManagerException {
        if (this._startAction == null || !workerName.equals(this._startAction.getWorker()) || !this._workers.get(workerName).getModes().contains((Object)WorkerDefinition.Mode.BULKSOURCE)) {
            throw new JobManagerException("Worker '" + workerName + "' is not defined as start action for job '" + this._jobDef.getName() + "' or has no '" + WorkerDefinition.Mode.BULKSOURCE.toString() + "' mode.");
        }
        List<Task> taskList = this.generateTasksForAction(workflowRunId, null, this._startAction, null);
        if (taskList.size() != 1) {
            throw new JobManagerException("Not exactly one initial task produced for worker '" + workerName + "' in workflow run '" + workflowRunId + "'.");
        }
        return taskList.get(0);
    }

    public List<Task> getFollowupTasks(String workflowRunId, MultiValueMap<String, BulkInfo> bucketNameToReallyCreatedBulksMap, AnyMap taskParamsToCopy) throws TaskGeneratorException {
        ArrayList<Task> followUpTasks = new ArrayList<Task>();
        Collection<WorkflowAction> followUpActions = this.getFollowupWorkflowActions(bucketNameToReallyCreatedBulksMap.keySet());
        for (WorkflowAction action : followUpActions) {
            followUpTasks.addAll(this.generateTasksForAction(workflowRunId, bucketNameToReallyCreatedBulksMap, action, taskParamsToCopy));
        }
        return followUpTasks;
    }

    public List<Task> getInitialRunOnceTasks(String workflowRunId) throws TaskGeneratorException {
        TaskGenerator taskGenerator = this.getTaskGenerator(this._startAction);
        AnyMap paramExpressions = DataFactory.DEFAULT.createAnyMap();
        if (this._parameters != null) {
            paramExpressions.putAll((Map)this._parameters);
        }
        if (this._startAction.getParameters() != null) {
            paramExpressions.putAll((Map)this._startAction.getParameters());
        }
        AnyMap parameters = ExpressionUtil.evaluateParameters(paramExpressions);
        Map<String, Bucket> inputSlotNameToBucket = this._actionInputBuckets.get(this._startAction);
        Map<String, Bucket> outputSlotNameToBucketMap = this._actionOutputBuckets.get(this._startAction);
        List<Task> tasks = taskGenerator.createRunOnceTasks(inputSlotNameToBucket, outputSlotNameToBucketMap, parameters, this._startAction.getWorker());
        this.setAdditionalTaskProperties(tasks, workflowRunId, this._startAction.getWorker());
        return tasks;
    }

    public boolean isTriggeredBy(Bucket triggeringBucket) {
        if (this._startAction.getInput() != null) {
            for (String inputBucketName : this._startAction.getInput().values()) {
                Bucket inputBucket = this.getBucket(inputBucketName);
                if (!inputBucket.isPersistent() || !triggeringBucket.getBucketId().equals(inputBucket.getBucketId())) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<Bucket> getTriggerBuckets() {
        ArrayList<Bucket> startBuckets = new ArrayList<Bucket>();
        if (this._startAction.getInput() != null) {
            for (String inputBucketName : this._startAction.getInput().values()) {
                Bucket inputBucket = this.getBucket(inputBucketName);
                if (!inputBucket.isPersistent()) continue;
                startBuckets.add(inputBucket);
            }
        }
        return startBuckets;
    }

    public List<Task> getTriggeredInitialTasks(MultiValueMap<String, BulkInfo> bucketNameToReallyCreatedBulksMap) throws TaskGeneratorException {
        return this.generateTasksForAction(null, bucketNameToReallyCreatedBulksMap, this._startAction, null);
    }

    private List<Task> generateTasksForAction(String workflowRunId, MultiValueMap<String, BulkInfo> bucketNameToReallyCreatedBulksMap, WorkflowAction action, AnyMap taskParamsToCopy) throws TaskGeneratorException {
        TaskGenerator taskGenerator = this.getTaskGenerator(action);
        AnyMap paramExpressions = DataFactory.DEFAULT.createAnyMap();
        if (this._parameters != null) {
            paramExpressions.putAll((Map)this._parameters);
        }
        if (action.getParameters() != null) {
            paramExpressions.putAll((Map)action.getParameters());
        }
        AnyMap parameters = ExpressionUtil.evaluateParameters(paramExpressions);
        if (taskParamsToCopy != null) {
            parameters.putAll((Map)taskParamsToCopy);
        }
        Map<String, Bucket> inputSlotNameToBucket = this._actionInputBuckets.get(action);
        Map<String, Bucket> outputSlotNameToBucketMap = this._actionOutputBuckets.get(action);
        MultiValueMap<String, BulkInfo> changedInputSlotToBulkListMap = this.prepareInputSlots(action, bucketNameToReallyCreatedBulksMap);
        long start = System.currentTimeMillis();
        List<Task> tasks = taskGenerator.createTasks((Map<String, List<BulkInfo>>)changedInputSlotToBulkListMap, inputSlotNameToBucket, outputSlotNameToBucketMap, parameters, action.getWorker());
        long t = System.currentTimeMillis() - start;
        if (t > 1000L) {
            this._log.info((Object)("TaskGenerator time for creating tasks: " + t));
        }
        this.setAdditionalTaskProperties(tasks, workflowRunId, action.getWorker());
        if (taskParamsToCopy != null) {
            for (Task followUpTask : tasks) {
                for (Map.Entry param : taskParamsToCopy.entrySet()) {
                    followUpTask.getParameters().put((String)param.getKey(), (Any)param.getValue());
                }
            }
        }
        return tasks;
    }

    private void setAdditionalTaskProperties(List<Task> tasks, String workflowRunId, String workerName) {
        WorkerDefinition worker = this.getWorkerDefinition(workerName);
        String qualifierSlot = null;
        for (WorkerDefinition.Input input : worker.getInput()) {
            if (!input.getModes().contains((Object)WorkerDefinition.InputMode.QUALIFIER)) continue;
            qualifierSlot = input.getName();
        }
        for (Task task : tasks) {
            List inputBulks;
            task.getProperties().put("workflowRunId", workflowRunId);
            task.getProperties().put("jobRunId", this._jobRunId);
            task.getProperties().put("jobName", this._jobDef.getName());
            if (qualifierSlot == null || (inputBulks = (List)task.getInputBulks().get(qualifierSlot)) == null || inputBulks.isEmpty()) continue;
            BulkInfo firstBulk = (BulkInfo)inputBulks.get(0);
            task.setQualifier(firstBulk.getObjectName());
        }
    }

    private TaskGenerator getTaskGenerator(WorkflowAction action) {
        WorkerDefinition worker = this._workers.get(action.getWorker());
        TaskGenerator taskGenerator = worker.getTaskGenerator() != null && !worker.getTaskGenerator().equals("") ? this._taskGeneratorProvider.getTaskGenerator(worker.getTaskGenerator()) : this._taskGeneratorProvider.getDefaultTaskGenerator();
        return taskGenerator;
    }

    private MultiValueMap<String, BulkInfo> prepareInputSlots(WorkflowAction action, MultiValueMap<String, BulkInfo> bucketNameToReallyCreatedBulksMap) {
        MultiValueMap changedInputSlotToBulkListMap = new MultiValueMap();
        Map<String, String> actionInput = action.getInput();
        if (actionInput != null) {
            for (Map.Entry<String, String> actionInputEntry : actionInput.entrySet()) {
                List bulkInfoList = (List)bucketNameToReallyCreatedBulksMap.get((Object)actionInputEntry.getValue());
                if (bulkInfoList == null) continue;
                for (BulkInfo inputBulk : bulkInfoList) {
                    if (inputBulk == null) continue;
                    if (!changedInputSlotToBulkListMap.containsKey((Object)actionInputEntry.getKey())) {
                        changedInputSlotToBulkListMap.put((Object)actionInputEntry.getKey(), new ArrayList());
                    }
                    ((List)changedInputSlotToBulkListMap.get((Object)actionInputEntry.getKey())).add(inputBulk);
                }
            }
        }
        return changedInputSlotToBulkListMap;
    }

    private Collection<WorkflowAction> getFollowupWorkflowActions(Collection<String> bucketNames) {
        HashSet<WorkflowAction> followUpActions = new HashSet<WorkflowAction>();
        for (String bucketName : bucketNames) {
            List actions = (List)this._bucketToTriggeredAction.get((Object)bucketName);
            if (actions == null) continue;
            followUpActions.addAll(actions);
        }
        return followUpActions;
    }
}

