/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.smila.jobmanager.BucketDefinition;
import org.eclipse.smila.jobmanager.DataObjectTypeDefinition;
import org.eclipse.smila.jobmanager.JobDefinition;
import org.eclipse.smila.jobmanager.WorkerDefinition;
import org.eclipse.smila.jobmanager.WorkflowDefinition;
import org.eclipse.smila.jobmanager.persistence.DefinitionStorage;
import org.eclipse.smila.jobmanager.persistence.PersistenceException;

public class DefinitionAccessor {
    private DefinitionStorage _storage;
    private Map<String, DataObjectTypeDefinition> _configuredDataObjectTypes = new HashMap<String, DataObjectTypeDefinition>();
    private Map<String, WorkerDefinition> _configuredWorkers = new HashMap<String, WorkerDefinition>();
    private Map<String, BucketDefinition> _configuredBuckets = new HashMap<String, BucketDefinition>();
    private Map<String, WorkflowDefinition> _configuredWorkflows = new HashMap<String, WorkflowDefinition>();

    public void setStorage(DefinitionStorage storage) {
        this._storage = storage;
    }

    public Collection<String> getDataObjectTypes() {
        return new ArrayList<String>(this._configuredDataObjectTypes.keySet());
    }

    public DataObjectTypeDefinition getDataObjectType(String name) {
        return this._configuredDataObjectTypes.get(name);
    }

    public Collection<String> getWorkers() {
        return new ArrayList<String>(this._configuredWorkers.keySet());
    }

    public WorkerDefinition getWorker(String name) {
        return this._configuredWorkers.get(name);
    }

    public Collection<String> getBuckets() throws PersistenceException {
        Collection<String> storageBuckets;
        ArrayList<String> bucketNames = new ArrayList<String>(this._configuredBuckets.keySet());
        if (this._storage != null && (storageBuckets = this._storage.getBuckets()) != null) {
            bucketNames.addAll(storageBuckets);
        }
        return bucketNames;
    }

    public BucketDefinition getBucket(String name) throws PersistenceException {
        if (this._configuredBuckets.containsKey(name)) {
            return this._configuredBuckets.get(name);
        }
        if (this._storage != null) {
            return this._storage.getBucket(name);
        }
        return null;
    }

    public Collection<String> getJobs() throws PersistenceException {
        Collection<String> storageJobs;
        ArrayList<String> jobNames = new ArrayList<String>();
        if (this._storage != null && (storageJobs = this._storage.getJobs()) != null) {
            jobNames.addAll(storageJobs);
        }
        return jobNames;
    }

    public JobDefinition getJob(String name) throws PersistenceException {
        if (this._storage != null) {
            return this._storage.getJob(name);
        }
        return null;
    }

    public Collection<String> getWorkflows() throws PersistenceException {
        Collection<String> storageWorkflows;
        HashSet<String> workflowNames = new HashSet<String>(this._configuredWorkflows.keySet());
        if (this._storage != null && (storageWorkflows = this._storage.getWorkflows()) != null) {
            workflowNames.addAll(storageWorkflows);
        }
        return workflowNames;
    }

    public WorkflowDefinition getWorkflow(String name) throws PersistenceException {
        if (this._configuredWorkflows.containsKey(name)) {
            return this._configuredWorkflows.get(name);
        }
        if (this._storage != null) {
            return this._storage.getWorkflow(name);
        }
        return null;
    }

    public void setConfiguredDataObjectTypes(Map<String, DataObjectTypeDefinition> configuredDataObjectTypes) {
        this._configuredDataObjectTypes = configuredDataObjectTypes;
    }

    public void setConfiguredWorkers(Map<String, WorkerDefinition> configuredWorkers) {
        this._configuredWorkers = configuredWorkers;
    }

    public Map<String, BucketDefinition> getConfiguredBuckets() {
        return this._configuredBuckets;
    }

    public void setConfiguredBuckets(Map<String, BucketDefinition> configuredBuckets) {
        this._configuredBuckets = configuredBuckets;
    }

    public Map<String, WorkflowDefinition> getConfiguredWorkflows() {
        return this._configuredWorkflows;
    }

    public void setConfiguredWorkflows(Map<String, WorkflowDefinition> configuredWorkflows) {
        this._configuredWorkflows = configuredWorkflows;
    }
}

