/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.util;

import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.util.ValueExpression;

public final class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static AnyMap evaluateParameters(Map<String, ValueExpression> map) {
        AnyMap evaluatedMap = DataFactory.DEFAULT.createAnyMap();
        for (Map.Entry<String, ValueExpression> entry : map.entrySet()) {
            evaluatedMap.put(entry.getKey(), entry.getValue().evaluateExpr(map).getExpression());
        }
        return evaluatedMap;
    }

    public static AnyMap evaluateParameters(AnyMap map) {
        if (map == null) {
            return map;
        }
        AnyMap topLevelValues = DataFactory.DEFAULT.createAnyMap();
        for (Map.Entry entry : map.entrySet()) {
            if (!((Any)entry.getValue()).isValue()) continue;
            topLevelValues.put((String)entry.getKey(), (Any)((Any)entry.getValue()).asValue());
        }
        return (AnyMap)ExpressionUtil.evaluateParameter((Any)map, topLevelValues);
    }

    public static Any evaluateParameter(Any param, AnyMap topLevelValues) {
        if (param.isString()) {
            return DataFactory.DEFAULT.createStringValue(new ValueExpression(param.asValue().asString()).evaluate(topLevelValues).toString());
        }
        if (param.isMap()) {
            AnyMap evaluatedMap = DataFactory.DEFAULT.createAnyMap();
            for (Map.Entry entry : param.asMap().entrySet()) {
                evaluatedMap.put((String)entry.getKey(), ExpressionUtil.evaluateParameter((Any)entry.getValue(), topLevelValues));
            }
            return evaluatedMap;
        }
        if (param.isSeq()) {
            AnySeq evaluatedSeq = DataFactory.DEFAULT.createAnySeq();
            for (Any entry : param.asSeq()) {
                evaluatedSeq.add((Object)ExpressionUtil.evaluateParameter(entry, topLevelValues));
            }
            return evaluatedSeq;
        }
        return param;
    }
}

