/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.index.access;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.eclipse.smila.search.index.IndexException;
import org.eclipse.smila.search.lucene.index.access.ISynchronizedOperation;

public class ExistsOperation
implements ISynchronizedOperation<IndexReader, Boolean> {
    private final Term _term;

    public ExistsOperation(Term term) {
        this._term = term;
    }

    @Override
    public Boolean process(IndexReader object) throws IndexException {
        boolean exists;
        try {
            exists = object.docFreq(this._term) > 0;
        }
        catch (Exception e) {
            throw new IndexException("Unable to check wether document exists by term [" + this._term.text() + "]", (Throwable)e);
        }
        return exists;
    }
}

