/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.lucene.templates.transformer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.eclipse.smila.search.lucene.index.IndexConnection;
import org.eclipse.smila.search.lucene.messages.advsearch.DDateField;
import org.eclipse.smila.search.lucene.messages.advsearch.DNumField;
import org.eclipse.smila.search.lucene.messages.advsearch.DOP1;
import org.eclipse.smila.search.lucene.messages.advsearch.DOPN;
import org.eclipse.smila.search.lucene.messages.advsearch.DTerm;
import org.eclipse.smila.search.lucene.messages.indexstructure.DIndexField;
import org.eclipse.smila.search.lucene.tools.search.lucene.DTextFieldParameter;
import org.eclipse.smila.search.templates.NodeTransformer;
import org.eclipse.smila.search.templates.NodeTransformerException;
import org.eclipse.smila.search.utils.advsearch.ITermContent;
import org.eclipse.smila.search.utils.search.DField;
import org.eclipse.smila.search.utils.search.DNumberField;
import org.eclipse.smila.search.utils.search.DTextField;

public class ExtendedNodeTransformer
extends NodeTransformer {
    public ITermContent transformNode(DField dField) throws NodeTransformerException {
        if (dField instanceof DTextField) {
            DTextField dTextField = (DTextField)dField;
            boolean supportWildcardsForExactSearch = this.getParameterSet().getBooleanParameter("SupportWildcardsForExactSearch");
            DTextFieldParameter tfp = (DTextFieldParameter)dTextField.getParameter();
            List<TermInfo> terms = this.getTerms(dField, dTextField);
            DTextFieldParameter.DOperator operator = tfp.getOperator();
            DTextFieldParameter.DTolerance tolerance = tfp.getTolerance();
            boolean fuzzy = false;
            boolean parseWildcards = false;
            int slop = 0;
            if (tolerance == DTextFieldParameter.DTolerance.TOLERANT) {
                fuzzy = true;
                parseWildcards = true;
                IndexConnection ic = (IndexConnection)this.getIndexConnection();
                DIndexField indexField = (DIndexField)ic.getIndex().getIndexStructure().getField(dField.getFieldNo());
                if (indexField.getTokenize() && operator == DTextFieldParameter.DOperator.PHRASE) {
                    fuzzy = false;
                    parseWildcards = false;
                }
                TokenStream ts = ic.getAnalyzer().tokenStream(indexField.getName(), (Reader)new StringReader(dTextField.getText().trim()));
                try {
                    while (ts.next() != null) {
                        ++slop;
                    }
                }
                catch (IOException iOException) {}
                slop = (slop - 1) * 2;
            }
            if (terms.size() > 1 && operator != DTextFieldParameter.DOperator.PHRASE) {
                org.eclipse.smila.search.lucene.messages.advsearch.DTextField[] textFields = new org.eclipse.smila.search.lucene.messages.advsearch.DTextField[terms.size()];
                int i = 0;
                while (i < terms.size()) {
                    String text = terms.get(i).getText();
                    boolean parseWildcardsParam = parseWildcards;
                    if (supportWildcardsForExactSearch && (text.contains("*") || text.contains("?"))) {
                        parseWildcardsParam = true;
                    }
                    textFields[i] = new org.eclipse.smila.search.lucene.messages.advsearch.DTextField(dTextField.getFieldNo(), text, fuzzy, parseWildcardsParam, slop);
                    ++i;
                }
                DOPN op = new DOPN();
                if (operator == DTextFieldParameter.DOperator.AND) {
                    op.setOperation("AND");
                } else if (operator == DTextFieldParameter.DOperator.OR) {
                    op.setOperation("OR");
                } else {
                    op.setOperation("WMEAN");
                }
                int i2 = 0;
                while (i2 < textFields.length) {
                    if (terms.get(i2).isProhibited()) {
                        op.addTerm(new DTerm(new DOP1("NOT", new DTerm(textFields[i2]))));
                    } else {
                        op.addTerm(new DTerm(textFields[i2]));
                    }
                    ++i2;
                }
                return op;
            }
            String term = "";
            if (terms.size() != 0) {
                term = terms.get(0).getText();
            }
            boolean parseWildcardsParam = parseWildcards;
            if (supportWildcardsForExactSearch && (term.contains("*") || term.contains("?"))) {
                parseWildcardsParam = true;
            }
            return new org.eclipse.smila.search.lucene.messages.advsearch.DTextField(dTextField.getFieldNo(), term, fuzzy, parseWildcardsParam, slop);
        }
        if (dField instanceof DNumberField) {
            DNumberField dNumberField = (DNumberField)dField;
            return new DNumField(dNumberField.getFieldNo(), dNumberField.getMin(), dNumberField.getMax());
        }
        if (dField instanceof org.eclipse.smila.search.utils.search.DDateField) {
            org.eclipse.smila.search.utils.search.DDateField dDateField = (org.eclipse.smila.search.utils.search.DDateField)dField;
            return new DDateField(dDateField.getFieldNo(), dDateField.getDateMin().getTime(), dDateField.getDateMax().getTime());
        }
        throw new NodeTransformerException("unknown node type [" + dField.getClass().getName() + "]");
    }

    private List<TermInfo> getTerms(DField dField, DTextField dTextField) throws NodeTransformerException {
        IndexConnection ic = (IndexConnection)this.getIndexConnection();
        QueryParser qp = new QueryParser(ic.getIndex().getIndexStructure().getField(dField.getFieldNo()).getName(), ic.getAnalyzer());
        qp.setAllowLeadingWildcard(true);
        ArrayList<TermInfo> terms = new ArrayList<TermInfo>();
        try {
            Query q = qp.parse(dTextField.getText());
            if (q instanceof BooleanQuery) {
                BooleanClause[] clauses;
                BooleanQuery bq = (BooleanQuery)q;
                BooleanClause[] booleanClauseArray = clauses = bq.getClauses();
                int n = clauses.length;
                int n2 = 0;
                while (n2 < n) {
                    BooleanClause clause = booleanClauseArray[n2];
                    String term = this.getTerm(clause.getQuery());
                    terms.add(new TermInfo(clause.isProhibited(), term));
                    ++n2;
                }
            } else {
                String term = this.getTerm(q);
                terms.add(new TermInfo(false, term));
            }
        }
        catch (ParseException e) {
            throw new NodeTransformerException("unable to analyze query", (Throwable)e);
        }
        return terms;
    }

    private String getTerm(Query q) {
        if (q instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)q;
            return termQuery.getTerm().text();
        }
        if (q instanceof WildcardQuery) {
            WildcardQuery wildcardQuery = (WildcardQuery)q;
            return wildcardQuery.getTerm().text();
        }
        if (q instanceof PhraseQuery) {
            Term[] terms;
            PhraseQuery phraseQuery = (PhraseQuery)q;
            StringBuffer sb = new StringBuffer();
            Term[] termArray = terms = phraseQuery.getTerms();
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                sb.append(term.text()).append(' ');
                ++n2;
            }
            return sb.toString().trim();
        }
        if (q instanceof PrefixQuery) {
            PrefixQuery prefixQuery = (PrefixQuery)q;
            return String.valueOf(prefixQuery.getPrefix().text()) + "*";
        }
        return q.toString();
    }

    private static class TermInfo {
        private boolean _prohibited;
        private String _text;

        public TermInfo(boolean prohibited, String text) {
            this._prohibited = prohibited;
            this._text = text;
        }

        public boolean isProhibited() {
            return this._prohibited;
        }

        public void setProhibited(boolean prohibited) {
            this._prohibited = prohibited;
        }

        public String getText() {
            return this._text;
        }

        public void setText(String text) {
            this._text = text;
        }
    }
}

