/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.ipc;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.ipc.IpcSerializationUtils;

public class BinaryObjectStreamIterator {
    private final InputStream _binaryStream;
    private final IpcSerializationUtils _parser = new IpcSerializationUtils();
    private Any _nextObject;
    private boolean _finished;

    public BinaryObjectStreamIterator(InputStream binaryStream) {
        this._binaryStream = binaryStream;
    }

    public boolean hasNext() throws IOException {
        if (!this._finished) {
            try {
                if (this._nextObject == null) {
                    this._nextObject = this._parser.binaryStream2any(this._binaryStream);
                }
            }
            finally {
                if (this._nextObject == null) {
                    this.close();
                }
            }
        }
        return !this._finished;
    }

    public Any next() throws IOException {
        if (this._nextObject == null && !this.hasNext()) {
            throw new NoSuchElementException("No more objects available");
        }
        Any result = this._nextObject;
        this._nextObject = null;
        return result;
    }

    public void close() {
        this._nextObject = null;
        this._finished = true;
        IOUtils.closeQuietly((InputStream)this._binaryStream);
    }
}

