/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;

public class StaxRecordReader {
    private final DataFactory _dataFactory;

    public StaxRecordReader() {
        this(DataFactory.DEFAULT);
    }

    public StaxRecordReader(DataFactory dataFactory) {
        this._dataFactory = dataFactory;
    }

    public List<Record> readRecords(XMLStreamReader staxReader) throws XMLStreamException {
        ArrayList<Record> records = new ArrayList<Record>();
        if (this.isStartTag(staxReader, "RecordList")) {
            staxReader.nextTag();
            while (this.isStartTag(staxReader, "Record")) {
                records.add(this.readRecord(staxReader));
                staxReader.nextTag();
            }
        }
        return records;
    }

    public Record readRecord(XMLStreamReader staxReader) throws XMLStreamException {
        Record record = null;
        if (this.isStartTag(staxReader, "Record")) {
            record = this._dataFactory.createRecord();
            this.readElements(staxReader, record.getMetadata());
            this.readAttachments(staxReader, record);
        }
        return record;
    }

    private Value readValue(String value, String type) throws XMLStreamException {
        return this._dataFactory.parseFromString(value, type);
    }

    private void readValue(XMLStreamReader staxReader, Any container) throws XMLStreamException {
        String key = staxReader.getAttributeValue(null, "key");
        String valueType = staxReader.getAttributeValue(null, "type");
        String content = staxReader.getElementText();
        Value value = this.readValue(content, valueType);
        this.addToContainer(container, key, value);
    }

    private void readSeq(XMLStreamReader staxReader, Any container) throws XMLStreamException {
        String key = staxReader.getAttributeValue(null, "key");
        AnySeq seq = this._dataFactory.createAnySeq();
        this.readElements(staxReader, seq);
        this.addToContainer(container, key, seq);
    }

    private void readMap(XMLStreamReader staxReader, Any container) throws XMLStreamException {
        String key = staxReader.getAttributeValue(null, "key");
        AnyMap map = this._dataFactory.createAnyMap();
        this.readElements(staxReader, map);
        this.addToContainer(container, key, map);
    }

    private void readElements(XMLStreamReader staxReader, Any container) throws XMLStreamException {
        staxReader.nextTag();
        while (this.isStartTag(staxReader, "Val") || this.isStartTag(staxReader, "Seq") || this.isStartTag(staxReader, "Map")) {
            if (this.isStartTag(staxReader, "Val")) {
                this.readValue(staxReader, container);
            } else if (this.isStartTag(staxReader, "Seq")) {
                this.readSeq(staxReader, container);
            } else if (this.isStartTag(staxReader, "Map")) {
                this.readMap(staxReader, container);
            }
            staxReader.nextTag();
        }
    }

    private void readAttachments(XMLStreamReader staxReader, Record record) throws XMLStreamException {
        while (this.isStartTag(staxReader, "Attachment")) {
            String attachmentName = staxReader.getElementText();
            if (attachmentName != null && attachmentName.length() > 0) {
                record.setAttachment(attachmentName, null);
            }
            staxReader.nextTag();
        }
    }

    private boolean isStartTag(XMLStreamReader staxReader, String tagName) {
        return staxReader.isStartElement() && tagName.equals(staxReader.getLocalName());
    }

    private void addToContainer(Any container, String key, Any element) {
        if (container.isMap() && key != null) {
            ((AnyMap)container).put(key, element);
        } else if (container.isSeq()) {
            ((AnySeq)container).add(element);
        }
    }
}

