/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.taskmanager.BadParameterTaskmanagerException;
import org.eclipse.smila.taskmanager.ResultDescription;
import org.eclipse.smila.taskmanager.TaskManager;

public class TaskHandler
extends JsonRequestHandler {
    private TaskManager _taskManager;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        if ("POST".equals(method)) {
            String workerName = this.getWorkerName(requestUri);
            String taskId = this.getTaskId(requestUri);
            if (inputRecord == null) {
                this._taskManager.keepAlive(workerName, taskId);
            } else {
                ResultDescription resultDescription = ResultDescription.fromAny(inputRecord.getMetadata());
                this._taskManager.finishTask(workerName, taskId, resultDescription);
            }
        }
        return null;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalArgumentException) {
            return 400;
        }
        if (ex instanceof BadParameterTaskmanagerException && ((BadParameterTaskmanagerException)ex).getCauseCode().equals((Object)BadParameterTaskmanagerException.Cause.taskId)) {
            return 404;
        }
        if (ex instanceof BadParameterTaskmanagerException && ((BadParameterTaskmanagerException)ex).getCauseCode().equals((Object)BadParameterTaskmanagerException.Cause.workerName)) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected int getSuccessStatus(String requestMethod, String requestUri, Record inputRecord, Object resultObject) {
        if (inputRecord == null) {
            return 202;
        }
        return super.getSuccessStatus(requestMethod, requestUri, inputRecord, resultObject);
    }

    private String getWorkerName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    private String getTaskId(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 1) {
            return (String)uriParts.get(1);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "POST".equals(method);
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (this._taskManager == taskManager) {
            this._taskManager = null;
        }
    }
}

