/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.solr.search.SolrQueryParameterAccessor;

public class SolrQueryConverter {
    private final SolrQueryParameterAccessor _accessor;
    private final SolrQuery _solrQuery = new SolrQuery();

    public SolrQueryConverter(SolrQueryParameterAccessor accessor) {
        this._accessor = accessor;
    }

    public SolrQuery toSolrQuery() {
        String qt = this._accessor.getRequestHandler();
        this._solrQuery.setQueryType(qt);
        this.doQuerySettings();
        this.doTermsSettings();
        this.doFilterSettings();
        this.doFacetSettings();
        this.doHighlightingSettings();
        this.doShardsSettings();
        this.doSpellCheckSettings();
        return this._solrQuery;
    }

    private void doQuerySettings() {
        String q = this._accessor.getQuery();
        this._solrQuery.setQuery(q);
        int start = this._accessor.getOffset();
        this._solrQuery.setStart(Integer.valueOf(start));
        int rows = this._accessor.getMaxCount();
        this._solrQuery.setRows(Integer.valueOf(rows));
        String[] fl = this._accessor.getResultAttributes().toArray(new String[this._accessor.getResultAttributes().size()]);
        this._solrQuery.setFields(fl);
        this._solrQuery.addField("score");
        this._solrQuery.addField("Id");
    }

    private void doFilterSettings() {
        AnySeq seq = this._accessor.getFilterQuery();
        if (seq != null) {
            String[] fq = seq.asStrings().toArray(new String[seq.size()]);
            this._solrQuery.setFilterQueries(fq);
        }
    }

    private void doFacetSettings() {
        for (AnyMap groupby : this._accessor.getGroupByConfig()) {
            String attribute = groupby.getStringValue("attribute");
            if (attribute.equals("global.solr.params")) {
                this.addFacetParameter(groupby, null);
                continue;
            }
            String facet = groupby.getStringValue("_facet");
            if (!facet.equals("facet.query")) {
                this._solrQuery.add(facet, new String[]{attribute});
            }
            this.addFacetParameter(groupby, attribute);
        }
    }

    private void addFacetParameter(AnyMap groupby, String field) {
        for (String key : groupby.keySet()) {
            if (key.equals("attribute") || key.equals("_facet")) continue;
            if (key.equals("_fc")) {
                for (String fc : groupby.getSeq(key).asStrings()) {
                    this._solrQuery.add("facet.query", new String[]{String.valueOf(field) + ":" + fc});
                }
                continue;
            }
            String prefix = "";
            if (StringUtils.isNotBlank((String)field)) {
                prefix = "f." + field + ".";
            }
            this._solrQuery.add(String.valueOf(prefix) + key, new String[]{groupby.getStringValue(key)});
        }
    }

    private void doTermsSettings() {
        AnyMap terms = this._accessor.getTerms();
        if (terms != null) {
            this._solrQuery.setParam("qt", new String[]{"/terms"});
            this.setParameter(terms, null);
        }
    }

    private void doHighlightingSettings() {
        AnySeq seq = this._accessor.getHighlighting();
        if (seq != null) {
            for (Any map : seq) {
                if (!map.isMap()) continue;
                AnyMap highlighting = map.asMap();
                String attribute = highlighting.getStringValue("attribute");
                if (attribute.equals("global.solr.params")) {
                    this.setParameter(highlighting, null);
                    continue;
                }
                this.setParameter(highlighting, attribute);
            }
        }
    }

    private void setParameter(AnyMap map, String field) {
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("attribute")) continue;
            String value = ((Any)entry.getValue()).asValue().asString();
            if (StringUtils.isBlank((String)field)) {
                this._solrQuery.setParam(key, new String[]{value});
                continue;
            }
            String fieldKey = "f." + field + "." + key;
            this._solrQuery.setParam(fieldKey, new String[]{value});
        }
    }

    private void doShardsSettings() {
        AnySeq seq = this._accessor.getShards();
        if (seq != null) {
            String shards = StringUtils.join((Collection)seq.asStrings(), (String)",");
            this._solrQuery.setParam("shards", new String[]{shards});
        }
    }

    private void doSpellCheckSettings() {
        AnyMap spellcheck = this._accessor.getSpellcheck();
        if (spellcheck != null) {
            this.setParameter(spellcheck, null);
        }
    }
}

