/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Contexts {
    private static final Log __log = LogFactory.getLog(Contexts.class);
    TransactionManager txManager;
    MessageExchangeContext mexContext;
    Scheduler scheduler;
    EndpointReferenceContext eprContext;
    BindingContext bindingContext;
    BpelDAOConnectionFactory dao;
    final List<MessageExchangeInterceptor> globalIntereceptors = new CopyOnWriteArrayList<MessageExchangeInterceptor>();
    final List<BpelEventListener> eventListeners = new CopyOnWriteArrayList<BpelEventListener>();
    final Map<String, ExtensionBundleRuntime> extensionRegistry = new ConcurrentHashMap<String, ExtensionBundleRuntime>();
    final HashMap<QName, ExternalVariableModule> externalVariableEngines = new HashMap();

    Contexts() {
    }

    public boolean isTransacted() {
        try {
            return this.txManager.getStatus() == 0;
        }
        catch (SystemException systemException) {
            throw new BpelEngineException((Throwable)systemException);
        }
    }

    public void execTransaction(final Runnable runnable) {
        try {
            this.execTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    runnable.run();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            throw new BpelEngineException((Throwable)exception);
        }
    }

    public <T> T execTransaction(Callable<T> callable) throws Exception {
        try {
            this.txManager.begin();
        }
        catch (Exception exception) {
            String string = "Internal Error, could not begin transaction.";
            throw new BpelEngineException(string, (Throwable)exception);
        }
        boolean bl = false;
        try {
            T t = callable.call();
            bl = this.txManager.getStatus() != 1;
            T t2 = t;
            return t2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (bl) {
                try {
                    this.txManager.commit();
                }
                catch (Exception exception) {
                    __log.error((Object)"Commit failed.", (Throwable)exception);
                    throw new BpelEngineException("Commit failed.", (Throwable)exception);
                }
            }
            try {
                this.txManager.rollback();
            }
            catch (Exception exception) {
                __log.error((Object)"Transaction rollback failed.", (Throwable)exception);
            }
        }
    }

    public void setRollbackOnly() {
        try {
            this.txManager.setRollbackOnly();
        }
        catch (SystemException systemException) {
            __log.error((Object)"Transaction set rollback only failed.", (Throwable)systemException);
        }
    }

    public void registerCommitSynchronizer(final Runnable runnable) {
        try {
            this.txManager.getTransaction().registerSynchronization(new Synchronization(){

                public void afterCompletion(int n) {
                    if (n == 3) {
                        runnable.run();
                    }
                }

                public void beforeCompletion() {
                }
            });
        }
        catch (Exception exception) {
            throw new BpelEngineException("Error registering synchronizer.", (Throwable)exception);
        }
    }
}

