/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.parse;

import java.util.Arrays;
import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configured;
import org.eclipse.smila.connectivity.framework.crawler.web.metadata.Metadata;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.Outlink;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.ParseStatus;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.html.HTMLMetaTags;

public final class ParseData
extends Configured {
    private String _title;
    private Outlink[] _outlinks;
    private Metadata _contentMeta;
    private Metadata _parseMeta;
    private ParseStatus _status;
    private HTMLMetaTags _htmlMetaTags;

    public ParseData() {
    }

    public ParseData(ParseStatus status, String title, Outlink[] outlinks, Metadata contentMeta) {
        this(status, title, outlinks, contentMeta, new Metadata(), new HTMLMetaTags());
    }

    public ParseData(ParseStatus status, String title, Outlink[] outlinks, Metadata contentMeta, HTMLMetaTags htmlMetaTags) {
        this(status, title, outlinks, contentMeta, new Metadata(), htmlMetaTags);
    }

    public ParseData(ParseStatus status, String title, Outlink[] outlinks, Metadata contentMeta, Metadata parseMeta, HTMLMetaTags htmlMetaTags) {
        this._status = status;
        this._title = title;
        this._outlinks = outlinks;
        this._contentMeta = contentMeta;
        this._parseMeta = parseMeta;
        this._htmlMetaTags = htmlMetaTags;
    }

    public ParseStatus getStatus() {
        return this._status;
    }

    public String getTitle() {
        return this._title;
    }

    public Outlink[] getOutlinks() {
        return this._outlinks;
    }

    public Metadata getContentMeta() {
        return this._contentMeta;
    }

    public Metadata getParseMeta() {
        return this._parseMeta;
    }

    public void setParseMeta(Metadata parseMeta) {
        this._parseMeta = parseMeta;
    }

    public String getMeta(String name) {
        String value = this._parseMeta.get(name);
        if (value == null) {
            value = this._contentMeta.get(name);
        }
        return value;
    }

    public HTMLMetaTags getHtmlMetaTags() {
        return this._htmlMetaTags;
    }

    public void setHtmlMetaTags(HTMLMetaTags htmlMetaTags) {
        this._htmlMetaTags = htmlMetaTags;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParseData)) {
            return false;
        }
        ParseData other = (ParseData)o;
        return this._status.equals(other._status) && this._title.equals(other._title) && Arrays.equals(this._outlinks, other._outlinks) && this._contentMeta.equals(other._contentMeta) && this._parseMeta.equals(other._parseMeta);
    }

    public int hashCode() {
        return this._title.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Status: " + this._status + "\n");
        buffer.append("Title: " + this._title + "\n");
        if (this._outlinks != null) {
            buffer.append("Outlinks: " + this._outlinks.length + "\n");
            int i = 0;
            while (i < this._outlinks.length) {
                buffer.append("  outlink: " + this._outlinks[i] + "\n");
                ++i;
            }
        }
        buffer.append("Content Metadata: " + this._contentMeta + "\n");
        buffer.append("Parse Metadata: " + this._parseMeta + "\n");
        return buffer.toString();
    }
}

