/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClassHelper {
    public static final String[] EMPTY_SIGNATURE = new String[0];
    public static final Object[] EMPTY_PARAMS = new Object[0];
    private static final Class[] PRIMITIVES = new Class[]{Boolean.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE, Byte.TYPE, Character.TYPE};
    private static final Map<String, Class> PRIMITIVES_MAP = new HashMap<String, Class>();
    private static final Log LOG;

    static {
        int i = 0;
        while (i < PRIMITIVES.length) {
            Class c = PRIMITIVES[i];
            PRIMITIVES_MAP.put(c.getName(), c);
            ++i;
        }
        LOG = LogFactory.getLog(ClassHelper.class);
    }

    private ClassHelper() {
    }

    public static Class searchClass(String className) throws ReflectionException {
        Class pClass = PRIMITIVES_MAP.get(className);
        if (pClass != null) {
            return pClass;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e);
            throw new ReflectionException(e);
        }
    }
}

