/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.datadictionary.messages.ddconfig;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.ConfigurationException;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DDateField;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConfig;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConfigCodec;
import org.eclipse.smila.search.utils.search.DFieldCodec;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.IDFParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DDateFieldCodec {
    public static DFieldConfig decode(Element element) throws ConfigurationException {
        DDateField dDateField = new DDateField();
        DFieldConfigCodec.decodeStandardValues(dDateField, element);
        try {
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                String ln = nl.item(i).getLocalName();
                if (ln != null && ln.equals("Parameter")) {
                    dDateField.setParameter((IDFParameter)DFieldCodec.getParameter((Element)((Element)nl.item(i))));
                }
                ++i;
            }
        }
        catch (DSearchException e) {
            throw new ConfigurationException(e.getMessage());
        }
        return dDateField;
    }

    public static Element encode(DDateField dDateField, Element element) throws ConfigurationException {
        Document doc = element.getOwnerDocument();
        Element el = doc.createElementNS("http://www.anyfinder.de/DataDictionary/Configuration", "FieldConfig");
        element.appendChild(el);
        el.setAttribute("xsi:type", "FTDate");
        DFieldConfigCodec.encodeStandardValues(dDateField, el);
        if (dDateField.getParameter() != null) {
            Class encoder = dDateField.getParameter().getCodecClass();
            Method m = null;
            if (encoder != null) {
                try {
                    m = encoder.getMethod("encode", IDFParameter.class, Element.class);
                }
                catch (NoSuchMethodException e) {
                    throw new ConfigurationException("unable to locate encoder method", e);
                }
                try {
                    m.invoke(null, dDateField.getParameter(), el);
                }
                catch (InvocationTargetException e) {
                    throw new ConfigurationException("unable to invoke encoder method", e);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException("unable to invoke encoder method", e);
                }
            }
            throw new ConfigurationException("encoder for parameter must not be equal to null");
        }
        return el;
    }
}

