/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.datadictionary.messages.ddconfig;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.ConfigurationException;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DDateField;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DDateFieldCodec;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DFieldConfig;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DNumberField;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DNumberFieldCodec;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DTextField;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.DTextFieldCodec;
import org.eclipse.smila.search.datadictionary.messages.ddconfig.ICodecClass;
import org.eclipse.smila.search.utils.search.DSearchException;
import org.eclipse.smila.search.utils.search.parameterobjects.DNodeTransformer;
import org.eclipse.smila.search.utils.search.parameterobjects.DNodeTransformerCodec;
import org.eclipse.smila.search.utils.search.parameterobjects.DTransformer;
import org.eclipse.smila.search.utils.search.parameterobjects.DTransformerCodec;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DFieldConfigCodec {
    public static final String NS = "http://www.anyfinder.de/DataDictionary/Configuration";

    protected static DFieldConfig decode(Element element) throws ConfigurationException {
        String type = element.getAttribute("xsi:type");
        DFieldConfig fc = null;
        if (type.equals("FTText")) {
            fc = DTextFieldCodec.decode(element);
        } else if (type.equals("FTDate")) {
            fc = DDateFieldCodec.decode(element);
        } else if (type.equals("FTNumber")) {
            fc = DNumberFieldCodec.decode(element);
        } else {
            throw new ConfigurationException("Unknown field type '" + type + "'");
        }
        fc.setType(type);
        return fc;
    }

    public static void decodeStandardValues(DFieldConfig dField, Element element) throws ConfigurationException {
        Log log = LogFactory.getLog(DFieldConfigCodec.class);
        if (element.hasAttribute("Weight")) {
            dField.setWeight(new Integer(element.getAttribute("Weight")));
        }
        if (element.hasAttribute("FieldTemplate")) {
            dField.setFieldTemplate(element.getAttribute("FieldTemplate"));
        }
        if (element.hasAttribute("Constraint")) {
            dField.setConstraint(element.getAttribute("Constraint"));
        }
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                Element el = (Element)nl.item(i);
                if ("Transformer".equals(el.getLocalName())) {
                    try {
                        dField.setTransformer(DTransformerCodec.decode((Element)el));
                    }
                    catch (DSearchException e) {
                        log.error((Object)("Unable to decode Transformer: " + e.getMessage()), (Throwable)e);
                        throw new ConfigurationException("Unable to decode Transformer: " + e.getMessage());
                    }
                }
                if ("NodeTransformer".equals(el.getLocalName())) {
                    try {
                        dField.setNodeTransformer(DNodeTransformerCodec.decode((Element)el));
                    }
                    catch (DSearchException e) {
                        log.error((Object)("Unable to decode NodeTransformer: " + e.getMessage()), (Throwable)e);
                        throw new ConfigurationException("Unable to decode NodeTransformer: " + e.getMessage());
                    }
                }
            }
            ++i;
        }
    }

    protected static Element encode(DFieldConfig dField, Element element) throws ConfigurationException {
        if (dField instanceof ICodecClass) {
            ICodecClass iCodecClass = (ICodecClass)((Object)dField);
            Class encoder = iCodecClass.getCodecClass();
            Method m = null;
            try {
                m = dField instanceof DTextField ? encoder.getMethod("encode", DTextField.class, Element.class) : (dField instanceof DNumberField ? encoder.getMethod("encode", DNumberField.class, Element.class) : encoder.getMethod("encode", DDateField.class, Element.class));
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException("unable to locate encoder method", e);
            }
            try {
                return (Element)m.invoke(null, dField, element);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("unable to invoke encoder method", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("unable to invoke encoder method", e);
            }
        }
        if (dField instanceof DDateField) {
            return DDateFieldCodec.encode((DDateField)dField, element);
        }
        if (dField instanceof DNumberField) {
            return DNumberFieldCodec.encode((DNumberField)dField, element);
        }
        if (dField instanceof DTextField) {
            return DTextFieldCodec.encode((DTextField)dField, element);
        }
        if (dField == null) {
            return null;
        }
        throw new ConfigurationException("Unknown field element " + dField.getClass());
    }

    public static void encodeStandardValues(DFieldConfig dField, Element element) throws ConfigurationException {
        Log log = LogFactory.getLog(DFieldConfigCodec.class);
        if (dField.getWeight() != null) {
            element.setAttribute("Weight", "" + dField.getWeight());
        }
        if (dField.getFieldTemplate() != null) {
            element.setAttribute("FieldTemplate", dField.getFieldTemplate());
        }
        if (dField.getConstraint() != null) {
            element.setAttribute("Constraint", dField.getConstraint());
        }
        if (dField.getNodeTransformer() != null) {
            try {
                DNodeTransformerCodec.encode((DNodeTransformer)dField.getNodeTransformer(), (Element)element);
            }
            catch (DSearchException e) {
                log.error((Object)("Unable to encode NodeTransformer: " + e.getMessage()), (Throwable)e);
                throw new ConfigurationException("Unable to encode NodeTransformer: " + e.getMessage());
            }
        }
        if (dField.getTransformer() != null) {
            try {
                DTransformerCodec.encode((DTransformer)dField.getTransformer(), (Element)element);
            }
            catch (DSearchException e1) {
                log.error((Object)("Unable to encode Transformer: " + e1.getMessage()), (Throwable)e1);
                throw new ConfigurationException("Unable to encode Transformer: " + e1.getMessage());
            }
        }
    }

    private DFieldConfigCodec() {
    }
}

