/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.util;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;

public class ResultCollector {
    private ParameterAccessor _paramAccessor;
    private Log _log;
    private boolean _dropRecordOnError;
    private Collection<String> _results = new ArrayList<String>();

    public ResultCollector(ParameterAccessor paramAccessor, Log log, boolean dropRecordOnError) {
        if (paramAccessor == null) {
            throw new IllegalArgumentException("Parameter 'paramAccessor' is null");
        }
        this._paramAccessor = paramAccessor;
        if (log != null) {
            this._log = log;
        }
        this._dropRecordOnError = dropRecordOnError;
    }

    public void addResult(String recordId) {
        this._results.add(recordId);
    }

    public void addFailedResult(String recordId, Exception ex) throws ProcessingException {
        this._paramAccessor.setCurrentRecord(recordId);
        boolean failOnError = this._paramAccessor.getBooleanParameter("_failOnError", true);
        if (failOnError) {
            if (ex instanceof ProcessingException) {
                throw (ProcessingException)((Object)ex);
            }
            throw new ProcessingException(ex);
        }
        String errorMessage = "Error while processing record with id '" + recordId + "'.";
        if (this._dropRecordOnError) {
            errorMessage = String.valueOf(errorMessage) + errorMessage + " Record will be removed from pipelet result.";
        } else {
            this._results.add(recordId);
        }
        if (this._log != null) {
            this._log.warn((Object)errorMessage, (Throwable)ex);
        }
    }

    public String[] getResultIds() {
        return this._results.toArray(new String[this._results.size()]);
    }
}

