/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.BindingContextImpl;
import org.apache.ode.axis2.EndpointReferenceContextImpl;
import org.apache.ode.axis2.ExternalService;
import org.apache.ode.axis2.MessageExchangeContextImpl;
import org.apache.ode.axis2.Messages;
import org.apache.ode.axis2.ODEConfigProperties;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.axis2.deploy.DeploymentPoller;
import org.apache.ode.axis2.hooks.ODEAxisService;
import org.apache.ode.axis2.hooks.ODEMessageReceiver;
import org.apache.ode.axis2.httpbinding.HttpExternalService;
import org.apache.ode.axis2.service.DeploymentWebService;
import org.apache.ode.axis2.service.ManagementService;
import org.apache.ode.axis2.soapbinding.SoapExternalService;
import org.apache.ode.bpel.connector.BpelServerConnector;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.CountLRUDehydrationPolicy;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evtproc.DebugBpelEventListener;
import org.apache.ode.bpel.extension.ExtensionBundleRuntime;
import org.apache.ode.bpel.extension.ExtensionBundleValidation;
import org.apache.ode.bpel.extvar.jdbc.JdbcExternalVariableModule;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.bpel.iapi.ProcessStoreListener;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.pmapi.InstanceManagement;
import org.apache.ode.bpel.pmapi.ProcessManagement;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.Database;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.JdbcDelegate;
import org.apache.ode.scheduler.simple.SimpleScheduler;
import org.apache.ode.store.ProcessStoreImpl;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.fs.TempFileManager;
import org.apache.ode.utils.wsdl.WsdlUtils;

public class ODEServer {
    protected final Log __log = LogFactory.getLog(this.getClass());
    protected final Log __logTx = LogFactory.getLog((String)"org.apache.ode.tx");
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    protected File _appRoot;
    protected File _configRoot;
    protected File _workRoot;
    protected BpelServerImpl _server;
    protected ProcessStoreImpl _store;
    protected ODEConfigProperties _odeConfig;
    protected AxisConfiguration _axisConfig;
    protected TransactionManager _txMgr;
    protected BpelDAOConnectionFactory _daoCF;
    protected Scheduler _scheduler;
    protected Database _db;
    private DeploymentPoller _poller;
    private MultiKeyMap _services = new MultiKeyMap();
    private MultiKeyMap _externalServices = new MultiKeyMap();
    private BpelServerConnector _connector;
    private ManagementService _mgtService;

    public void init(ServletConfig servletConfig, AxisConfiguration axisConfiguration) throws ServletException {
        this.init(servletConfig.getServletContext().getRealPath("/WEB-INF"), axisConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String string, AxisConfiguration axisConfiguration) throws ServletException {
        boolean bl = false;
        try {
            Object object;
            this._axisConfig = axisConfiguration;
            String string2 = System.getProperty("org.apache.ode.rootDir");
            this._appRoot = string2 != null ? new File(string2) : new File(string);
            if (!this._appRoot.isDirectory()) {
                throw new IllegalArgumentException(this._appRoot + " does not exist or is not a directory");
            }
            TempFileManager.setWorkingDirectory((File)this._appRoot);
            this.__log.debug((Object)"Loading properties");
            String string3 = System.getProperty("org.apache.ode.configDir");
            File file = this._configRoot = string3 == null ? new File(this._appRoot, "conf") : new File(string3);
            if (!this._configRoot.isDirectory()) {
                throw new IllegalArgumentException(this._configRoot + " does not exist or is not a directory");
            }
            this._odeConfig = new ODEConfigProperties(this._configRoot);
            try {
                this._odeConfig.load();
            }
            catch (FileNotFoundException fileNotFoundException) {
                object = __msgs.msgOdeInstallErrorCfgNotFound(this._odeConfig.getFile());
                this.__log.warn(object);
            }
            catch (Exception exception) {
                String string4 = __msgs.msgOdeInstallErrorCfgReadError(this._odeConfig.getFile());
                this.__log.error((Object)string4, (Throwable)exception);
                throw new ServletException(string4, (Throwable)exception);
            }
            String string5 = this._odeConfig.getWorkingDir();
            this._workRoot = string5 == null ? this._appRoot : new File(string5.trim());
            if (!this._workRoot.isDirectory()) {
                throw new IllegalArgumentException(this._workRoot + " does not exist or is not a directory");
            }
            this.__log.debug((Object)"Initializing transaction manager");
            this.initTxMgr();
            this.__log.debug((Object)"Creating data source.");
            this.initDataSource();
            this.__log.debug((Object)"Starting DAO.");
            this.initDAO();
            object = new EndpointReferenceContextImpl(this);
            this.__log.debug((Object)"Initializing BPEL process store.");
            this.initProcessStore((EndpointReferenceContext)object);
            this.__log.debug((Object)"Initializing BPEL server.");
            this.initBpelServer((EndpointReferenceContextImpl)object);
            this.registerEventListeners();
            this.registerMexInterceptors();
            this.registerExtensionActivityBundles();
            this.registerExternalVariableModules();
            try {
                this._server.start();
            }
            catch (Exception exception) {
                String string6 = __msgs.msgOdeBpelServerStartFailure();
                this.__log.error((Object)string6, (Throwable)exception);
                throw new ServletException(string6, (Throwable)exception);
            }
            File file2 = new File(this._workRoot, "processes");
            this._poller = new DeploymentPoller(file2, this);
            this._mgtService = new ManagementService();
            this._mgtService.enableService(this._axisConfig, (BpelServer)this._server, (ProcessStore)this._store, this._appRoot.getAbsolutePath());
            new DeploymentWebService().enableService(this._axisConfig, (BpelServer)this._server, (ProcessStore)this._store, this._poller, this._appRoot.getAbsolutePath(), this._workRoot.getAbsolutePath());
            this._store.loadAll();
            this.__log.debug((Object)"Initializing JCA adapter.");
            this.initConnector();
            this._poller.start();
            this.__log.info((Object)__msgs.msgPollingStarted(file2.getAbsolutePath()));
            this.__log.info((Object)__msgs.msgOdeStarted());
            bl = true;
        }
        finally {
            if (!bl) {
                // empty if block
            }
        }
    }

    private void initDataSource() throws ServletException {
        this._db = new Database((OdeConfigProperties)this._odeConfig);
        this._db.setTransactionManager(this._txMgr);
        this._db.setWorkRoot(this._workRoot);
        try {
            this._db.start();
        }
        catch (Exception exception) {
            String string = __msgs.msgOdeDbConfigError();
            this.__log.error((Object)string, (Throwable)exception);
            throw new ServletException(string, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws AxisFault {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (this._poller != null) {
                try {
                    this.__log.debug((Object)"shutting down poller");
                    this._poller.stop();
                    this._poller = null;
                }
                catch (Throwable throwable) {
                    this.__log.debug((Object)"Error stopping poller.", throwable);
                }
            }
            if (this._server != null) {
                try {
                    this.__log.debug((Object)"shutting down ODE server.");
                    this._server.shutdown();
                    this._server = null;
                }
                catch (Throwable throwable) {
                    this.__log.debug((Object)"Error stopping services.", throwable);
                }
            }
            if (this._scheduler != null) {
                try {
                    this.__log.debug((Object)"shutting down quartz scheduler.");
                    this._scheduler.shutdown();
                    this._scheduler = null;
                }
                catch (Exception exception) {
                    this.__log.debug((Object)"Scheduler couldn't be shutdown.", (Throwable)exception);
                }
            }
            if (this._store != null) {
                try {
                    this._store.shutdown();
                    this._store = null;
                }
                catch (Throwable throwable) {
                    this.__log.debug((Object)"Store could not be shutdown.", throwable);
                }
            }
            if (this._daoCF != null) {
                try {
                    this._daoCF.shutdown();
                }
                catch (Throwable throwable) {
                    this.__log.debug((Object)"DOA shutdown failed.", throwable);
                }
                finally {
                    this._daoCF = null;
                }
            }
            if (this._db != null) {
                try {
                    this._db.shutdown();
                }
                catch (Throwable throwable) {
                    this.__log.debug((Object)"DB shutdown failed.", throwable);
                }
                finally {
                    this._db = null;
                }
            }
            if (this._txMgr != null) {
                this.__log.debug((Object)"shutting down transaction manager.");
                this._txMgr = null;
            }
            if (this._connector != null) {
                try {
                    this.__log.debug((Object)"shutdown BpelConnector");
                    this._connector.shutdown();
                }
                catch (Throwable throwable) {
                    this.__log.error((Object)"Unable to cleanup temp files.", throwable);
                }
            }
            try {
                this.__log.debug((Object)"cleaning up temporary files.");
                TempFileManager.cleanup();
            }
            catch (Throwable throwable) {
                this.__log.error((Object)"Unable to cleanup temp files.", throwable);
            }
            this.__log.info((Object)__msgs.msgOdeShutdownCompleted());
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public ODEService createService(ProcessConf processConf, QName qName, String string) throws AxisFault {
        QName qName2 = new QName(ODEAxisService.extractServiceName(processConf, qName, string));
        this.destroyService(qName2, string);
        AxisService axisService = ODEAxisService.createService(this._axisConfig, processConf, qName, string, qName2.getLocalPart());
        ODEService oDEService = new ODEService(axisService, processConf, qName, string, (BpelServer)this._server);
        this._services.put((Object)qName2, (Object)string, (Object)oDEService);
        Iterator iterator = axisService.getOperations();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            if (!(axisOperation.getMessageReceiver() instanceof ODEMessageReceiver)) continue;
            ((ODEMessageReceiver)axisOperation.getMessageReceiver()).setService(oDEService);
            break;
        }
        this._axisConfig.addService(axisService);
        this.__log.debug((Object)("Created Axis2 service " + qName));
        return oDEService;
    }

    public ExternalService createExternalService(ProcessConf processConf, QName qName, String string) throws ContextException {
        ExternalService externalService = (ExternalService)this._externalServices.get((Object)qName);
        if (externalService != null) {
            return externalService;
        }
        Definition definition = processConf.getDefinitionForService(qName);
        try {
            if (WsdlUtils.useHTTPBinding((Definition)definition, (QName)qName, (String)string)) {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Creating HTTP-bound external service " + qName));
                }
                externalService = new HttpExternalService(processConf, qName, string, (BpelServer)this._server);
            } else if (WsdlUtils.useSOAPBinding((Definition)definition, (QName)qName, (String)string)) {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Creating SOAP-bound external service " + qName));
                }
                externalService = new SoapExternalService(definition, qName, string, this._axisConfig, processConf);
            }
        }
        catch (Exception exception) {
            this.__log.error((Object)"Could not create external service.", (Throwable)exception);
            throw new ContextException("Error creating external service! name:" + qName + ", port:" + string, (Throwable)exception);
        }
        if (externalService == null) {
            throw new ContextException("Only SOAP and HTTP binding supported!");
        }
        this._externalServices.put((Object)qName, (Object)string, (Object)externalService);
        this.__log.debug((Object)("Created external service " + qName));
        return externalService;
    }

    public void destroyService(QName qName, String string) {
        this.__log.debug((Object)("Destroying service " + qName + " port " + string));
        ODEService oDEService = (ODEService)this._services.remove((Object)qName, (Object)string);
        if (oDEService != null) {
            try {
                this._axisConfig.removeService(oDEService.getAxisService().getName());
            }
            catch (AxisFault axisFault) {
                this.__log.error((Object)("Couldn't destroy service " + qName));
            }
        } else {
            this.__log.debug((Object)("Couldn't find service " + qName + " port " + string + " to destroy."));
        }
    }

    public ODEService getService(QName qName, String string) {
        return (ODEService)this._services.get((Object)qName, (Object)string);
    }

    public ODEService getService(QName qName, QName qName2) {
        for (Object e : this._services.values()) {
            ODEService oDEService = (ODEService)e;
            if (!oDEService.respondsTo(qName, qName2)) continue;
            return oDEService;
        }
        return null;
    }

    public ExternalService getExternalService(QName qName, String string) {
        return (ExternalService)this._externalServices.get((Object)qName, (Object)string);
    }

    private void initTxMgr() throws ServletException {
        String string = this._odeConfig.getTxFactoryClass();
        this.__log.debug((Object)("Initializing transaction manager using " + string));
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            Object obj = clazz.newInstance();
            this._txMgr = (TransactionManager)clazz.getMethod("getTransactionManager", null).invoke(obj, new Object[0]);
            if (this.__logTx.isDebugEnabled() && System.getProperty("ode.debug.tx") != null) {
                this._txMgr = new DebugTxMgr(this._txMgr);
            }
            this._axisConfig.addParameter("ode.transaction.manager", (Object)this._txMgr);
        }
        catch (Exception exception) {
            this.__log.fatal((Object)("Couldn't initialize a transaction manager with factory: " + string), (Throwable)exception);
            throw new ServletException("Couldn't initialize a transaction manager with factory: " + string, (Throwable)exception);
        }
    }

    private void initConnector() throws ServletException {
        int n = this._odeConfig.getConnectorPort();
        if (n == 0) {
            this.__log.info((Object)"Skipping connector initialization.");
        } else {
            this._connector = new BpelServerConnector();
            this._connector.setBpelServer((BpelServer)this._server);
            this._connector.setProcessStore((ProcessStore)this._store);
            this._connector.setPort(this._odeConfig.getConnectorPort());
            this._connector.setId(this._odeConfig.getConnectorName());
            try {
                this._connector.start();
            }
            catch (Exception exception) {
                this.__log.error((Object)"Failed to initialize JCA connector.", (Throwable)exception);
            }
        }
    }

    protected void initDAO() throws ServletException {
        this.__log.info((Object)__msgs.msgOdeUsingDAOImpl(this._odeConfig.getDAOConnectionFactory()));
        try {
            this._daoCF = this._db.createDaoCF();
        }
        catch (Exception exception) {
            String string = __msgs.msgDAOInstantiationFailed(this._odeConfig.getDAOConnectionFactory());
            this.__log.error((Object)string, (Throwable)exception);
            throw new ServletException(string, (Throwable)exception);
        }
    }

    protected void initProcessStore(EndpointReferenceContext endpointReferenceContext) {
        this._store = this.createProcessStore(endpointReferenceContext, this._db.getDataSource());
        this._store.registerListener((ProcessStoreListener)new ProcessStoreListenerImpl());
        this._store.setDeployDir(new File(this._workRoot, "processes"));
        this._store.setConfigDir(this._configRoot);
    }

    protected ProcessStoreImpl createProcessStore(EndpointReferenceContext endpointReferenceContext, DataSource dataSource) {
        return new ProcessStoreImpl(endpointReferenceContext, dataSource, this._odeConfig.getDAOConnectionFactory(), (OdeConfigProperties)this._odeConfig, false);
    }

    protected Scheduler createScheduler() {
        SimpleScheduler simpleScheduler = new SimpleScheduler(new GUID().toString(), (DatabaseDelegate)new JdbcDelegate(this._db.getDataSource()), this._odeConfig.getProperties());
        simpleScheduler.setTransactionManager(this._txMgr);
        return simpleScheduler;
    }

    protected void initBpelServer(EndpointReferenceContextImpl endpointReferenceContextImpl) {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)"ODE initializing");
        }
        this._server = new BpelServerImpl();
        this._scheduler = this.createScheduler();
        this._scheduler.setJobProcessor((Scheduler.JobProcessor)this._server);
        this._server.setDaoConnectionFactory(this._daoCF);
        this._server.setEndpointReferenceContext((EndpointReferenceContext)endpointReferenceContextImpl);
        this._server.setMessageExchangeContext((MessageExchangeContext)new MessageExchangeContextImpl(this));
        this._server.setBindingContext((BindingContext)new BindingContextImpl(this, (ProcessStore)this._store));
        this._server.setScheduler(this._scheduler);
        this._server.setTransactionManager(this._txMgr);
        if (this._odeConfig.isDehydrationEnabled()) {
            CountLRUDehydrationPolicy countLRUDehydrationPolicy = new CountLRUDehydrationPolicy();
            this._server.setDehydrationPolicy((DehydrationPolicy)countLRUDehydrationPolicy);
        }
        this._server.setConfigProperties((OdeConfigProperties)this._odeConfig);
        this._server.init();
    }

    public ProcessStoreImpl getProcessStore() {
        return this._store;
    }

    public BpelServerImpl getBpelServer() {
        return this._server;
    }

    public InstanceManagement getInstanceManagement() {
        return this._mgtService.getInstanceMgmt();
    }

    public ProcessManagement getProcessManagement() {
        return this._mgtService.getProcessMgmt();
    }

    public File getAppRoot() {
        return this._appRoot;
    }

    private void registerEventListeners() {
        this._server.registerBpelEventListener((BpelEventListener)new DebugBpelEventListener());
        String string = this._odeConfig.getEventListeners();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    this._server.registerBpelEventListener((BpelEventListener)Class.forName(string2).newInstance());
                    this.__log.info((Object)__msgs.msgBpelEventListenerRegistered(string2));
                }
                catch (Exception exception) {
                    this.__log.warn((Object)("Couldn't register the event listener " + string2 + ", the class couldn't be " + "loaded properly: " + exception));
                }
            }
        }
    }

    private void registerMexInterceptors() {
        String string = this._odeConfig.getMessageExchangeInterceptors();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    this._server.registerMessageExchangeInterceptor((MessageExchangeInterceptor)Class.forName(string2).newInstance());
                    this.__log.info((Object)__msgs.msgMessageExchangeInterceptorRegistered(string2));
                }
                catch (Exception exception) {
                    this.__log.warn((Object)("Couldn't register the event listener " + string2 + ", the class couldn't be " + "loaded properly: " + exception));
                }
            }
        }
    }

    private void registerExtensionActivityBundles() {
        Object object;
        Object object2;
        Object object3;
        String string = this._odeConfig.getExtensionActivityBundlesRT();
        String string2 = this._odeConfig.getExtensionActivityBundlesValidation();
        if (string != null) {
            object3 = new StringTokenizer(string, ",;");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken();
                try {
                    object = (ExtensionBundleRuntime)Class.forName((String)object2).newInstance();
                    this._server.registerExtensionBundle(object);
                }
                catch (Exception exception) {
                    this.__log.warn((Object)("Couldn't register the extension bundle runtime " + (String)object2 + ", the class couldn't be " + "loaded properly."));
                }
            }
        }
        if (string2 != null) {
            object3 = new HashMap();
            object2 = new StringTokenizer(string2, ",;");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                try {
                    ExtensionBundleValidation extensionBundleValidation = (ExtensionBundleValidation)Class.forName((String)object).newInstance();
                    object3.putAll(extensionBundleValidation.getExtensionValidators());
                }
                catch (Exception exception) {
                    this.__log.warn((Object)("Couldn't register the extension bundle validator " + (String)object + ", the class couldn't be " + "loaded properly."));
                }
            }
            this._store.setExtensionValidators((Map)object3);
        }
    }

    private void registerExternalVariableModules() {
        JdbcExternalVariableModule jdbcExternalVariableModule = new JdbcExternalVariableModule();
        jdbcExternalVariableModule.registerDataSource("ode", this._db.getDataSource());
        this._server.registerExternalVariableEngine((ExternalVariableModule)jdbcExternalVariableModule);
    }

    private void handleEvent(ProcessStoreEvent processStoreEvent) {
        this.__log.debug((Object)("Process store event: " + processStoreEvent));
        switch (processStoreEvent.type) {
            case ACTIVATED: 
            case RETIRED: {
                this._server.unregister(processStoreEvent.pid);
                ProcessConf processConf = this._store.getProcessConfiguration(processStoreEvent.pid);
                if (processConf != null) {
                    this._server.register(processConf);
                    break;
                }
                this.__log.debug((Object)("slighly odd: recevied event " + processStoreEvent + " for process not in store!"));
                break;
            }
            case DISABLED: 
            case UNDEPLOYED: {
                this._server.unregister(processStoreEvent.pid);
                break;
            }
            default: {
                this.__log.debug((Object)("Ignoring store event: " + processStoreEvent));
            }
        }
    }

    private class DebugTx
    implements Transaction {
        private Transaction _tx;

        public DebugTx(Transaction transaction) {
            this._tx = transaction;
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Tx commit");
            this._tx.commit();
        }

        public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
            return this._tx.delistResource(xAResource, n);
        }

        public boolean enlistResource(XAResource xAResource) throws IllegalStateException, RollbackException, SystemException {
            return this._tx.enlistResource(xAResource);
        }

        public int getStatus() throws SystemException {
            return this._tx.getStatus();
        }

        public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, RollbackException, SystemException {
            ODEServer.this.__logTx.debug((Object)("Synchronization registration on " + synchronization.getClass().getName()));
            this._tx.registerSynchronization(synchronization);
        }

        public void rollback() throws IllegalStateException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Tx rollback");
            this._tx.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Tx set rollback");
            this._tx.setRollbackOnly();
        }
    }

    private class DebugTxMgr
    implements TransactionManager {
        private TransactionManager _tm;

        public DebugTxMgr(TransactionManager transactionManager) {
            this._tm = transactionManager;
        }

        public void begin() throws NotSupportedException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm begin");
            this._tm.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm commit");
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                ODEServer.this.__logTx.debug((Object)stackTraceElement.toString());
            }
            this._tm.commit();
        }

        public int getStatus() throws SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm status");
            return this._tm.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            Transaction transaction = this._tm.getTransaction();
            ODEServer.this.__logTx.debug((Object)("Txm get tx " + transaction));
            return transaction == null ? null : new DebugTx(transaction);
        }

        public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm resume");
            this._tm.resume(transaction);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm rollback");
            this._tm.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm set rollback");
            this._tm.setRollbackOnly();
        }

        public void setTransactionTimeout(int n) throws SystemException {
            ODEServer.this.__logTx.debug((Object)("Txm set tiemout " + n));
            this._tm.setTransactionTimeout(n);
        }

        public Transaction suspend() throws SystemException {
            ODEServer.this.__logTx.debug((Object)"Txm suspend");
            return this._tm.suspend();
        }
    }

    private class ProcessStoreListenerImpl
    implements ProcessStoreListener {
        private ProcessStoreListenerImpl() {
        }

        public void onProcessStoreEvent(ProcessStoreEvent processStoreEvent) {
            ODEServer.this.handleEvent(processStoreEvent);
        }
    }
}

