/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.rapi.InvalidProcessException;
import org.apache.ode.bpel.rtrep.v1.ActivityInfo;
import org.apache.ode.bpel.rtrep.v1.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v1.CompensationHandler;
import org.apache.ode.bpel.rtrep.v1.LinkFrame;
import org.apache.ode.bpel.rtrep.v1.OEventHandler;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v1.SCOPE;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.Selector;
import org.apache.ode.bpel.rtrep.v1.VariableInstance;
import org.apache.ode.bpel.rtrep.v1.channels.EventHandlerControlChannel;
import org.apache.ode.bpel.rtrep.v1.channels.EventHandlerControlChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.bpel.rtrep.v1.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v1.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.PickResponseChannel;
import org.apache.ode.bpel.rtrep.v1.channels.PickResponseChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannel;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannelListener;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class EH_EVENT
extends BpelJacobRunnable {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(EH_EVENT.class);
    private EventHandlerControlChannel _ehc;
    private TerminationChannel _tc;
    private ParentScopeChannel _psc;
    private ScopeFrame _scopeFrame;
    private OEventHandler.OEvent _oevent;
    private Set<CompensationHandler> _comps = new HashSet<CompensationHandler>();
    private FaultData _fault;
    private Set<ActivityInfo> _active = new HashSet<ActivityInfo>();
    private boolean _stopped;
    private boolean _terminated;
    private boolean _childrenTerminated;

    EH_EVENT(ParentScopeChannel parentScopeChannel, TerminationChannel terminationChannel, EventHandlerControlChannel eventHandlerControlChannel, OEventHandler.OEvent oEvent, ScopeFrame scopeFrame) {
        this._scopeFrame = scopeFrame;
        this._oevent = oEvent;
        this._tc = terminationChannel;
        this._psc = parentScopeChannel;
        this._ehc = eventHandlerControlChannel;
    }

    public void run() {
        EH_EVENT.instance((JacobRunnable)new SELECT());
    }

    private void terminateActive() {
        if (!this._childrenTerminated) {
            for (ActivityInfo activityInfo : this._active) {
                ((TerminationChannel)EH_EVENT.replication((Channel)activityInfo.self)).terminate();
            }
            this._childrenTerminated = true;
        }
    }

    private class WAITING
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;
        private PickResponseChannel _pickResponseChannel;

        private WAITING(PickResponseChannel pickResponseChannel) {
            this._pickResponseChannel = pickResponseChannel;
        }

        public void run() {
            if (!EH_EVENT.this._active.isEmpty() || this._pickResponseChannel != null) {
                HashSet<ChannelListener> hashSet = new HashSet<ChannelListener>();
                if (!EH_EVENT.this._terminated) {
                    hashSet.add(new TerminationChannelListener(EH_EVENT.this._tc){
                        private static final long serialVersionUID = 7666910462948788042L;

                        public void terminate() {
                            EH_EVENT.this.terminateActive();
                            EH_EVENT.this._terminated = true;
                            if (WAITING.this._pickResponseChannel != null) {
                                WAITING.this.getBpelRuntime().cancel(WAITING.this._pickResponseChannel);
                            }
                            1.instance((JacobRunnable)WAITING.this);
                        }
                    });
                }
                if (!EH_EVENT.this._stopped) {
                    hashSet.add(new EventHandlerControlChannelListener(EH_EVENT.this._ehc){
                        private static final long serialVersionUID = -1050788954724647970L;

                        public void stop() {
                            EH_EVENT.this._stopped = true;
                            if (WAITING.this._pickResponseChannel != null) {
                                WAITING.this.getBpelRuntime().cancel(WAITING.this._pickResponseChannel);
                            }
                            2.instance((JacobRunnable)WAITING.this);
                        }
                    });
                }
                for (final ActivityInfo activityInfo : EH_EVENT.this._active) {
                    hashSet.add(new ParentScopeChannelListener(activityInfo.parent){
                        private static final long serialVersionUID = 5341207762415360982L;

                        @Override
                        public void compensate(OScope oScope, SynchChannel synchChannel) {
                            EH_EVENT.this._psc.compensate(oScope, synchChannel);
                            3.instance((JacobRunnable)WAITING.this);
                        }

                        @Override
                        public void completed(FaultData faultData, Set<CompensationHandler> set) {
                            EH_EVENT.this._active.remove(activityInfo);
                            EH_EVENT.this._comps.addAll(set);
                            if (faultData != null && EH_EVENT.this._fault == null) {
                                EH_EVENT.this._fault = faultData;
                                EH_EVENT.this.terminateActive();
                                EH_EVENT.this._psc.completed(EH_EVENT.this._fault, EH_EVENT.this._comps);
                            } else {
                                3.instance((JacobRunnable)WAITING.this);
                            }
                        }

                        @Override
                        public void cancelled() {
                            this.completed(null, CompensationHandler.emptySet());
                        }

                        @Override
                        public void failure(String string, Element element) {
                            this.completed(null, CompensationHandler.emptySet());
                        }
                    });
                }
                if (this._pickResponseChannel != null) {
                    hashSet.add(new PickResponseChannelListener(this._pickResponseChannel){
                        private static final long serialVersionUID = -4929999153478677288L;

                        public void onRequestRcvd(int n, String string) {
                            Serializable serializable;
                            Object object;
                            ScopeFrame scopeFrame = new ScopeFrame(EH_EVENT.this._oevent, WAITING.this.getBpelRuntime().createScopeInstance(((EH_EVENT)EH_EVENT.this)._scopeFrame.scopeInstanceId, EH_EVENT.this._oevent), EH_EVENT.this._scopeFrame, EH_EVENT.this._comps, EH_EVENT.this._fault);
                            if (((EH_EVENT)EH_EVENT.this)._oevent.variable != null && (object = WAITING.this.getBpelRuntime().getMyRequest(string)) != null) {
                                try {
                                    serializable = scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.variable);
                                    WAITING.this.getBpelRuntime().initializeVariable((VariableInstance)serializable, EH_EVENT.this._scopeFrame, (Node)object);
                                    VariableModificationEvent variableModificationEvent = new VariableModificationEvent(((VariableInstance)serializable).declaration.name);
                                    variableModificationEvent.setNewValue((Node)object);
                                    EH_EVENT.this._scopeFrame.fillEventInfo((ScopeEvent)variableModificationEvent);
                                    if (((EH_EVENT)EH_EVENT.this)._oevent.debugInfo != null) {
                                        variableModificationEvent.setLineNo(((EH_EVENT)EH_EVENT.this)._oevent.debugInfo.startLine);
                                    }
                                    WAITING.this.getBpelRuntime().sendEvent((ScopeEvent)variableModificationEvent);
                                }
                                catch (Exception exception) {
                                    __log.fatal((Object)exception);
                                    throw new InvalidProcessException(exception);
                                }
                            }
                            try {
                                object = ((EH_EVENT)EH_EVENT.this)._oevent.initCorrelations.iterator();
                                while (object.hasNext()) {
                                    serializable = (OScope.CorrelationSet)object.next();
                                    WAITING.this.initializeCorrelation(scopeFrame.resolve((OScope.CorrelationSet)serializable), scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.variable));
                                }
                                if (((EH_EVENT)EH_EVENT.this)._oevent.partnerLink.hasPartnerRole()) {
                                    if (!(WAITING.this.getBpelRuntime().isPartnerRoleEndpointInitialized(scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink)) && ((EH_EVENT)EH_EVENT.this)._oevent.partnerLink.initializePartnerRole || (object = WAITING.this.getBpelRuntime().getSourceEPR(string)) == null)) {
                                        WAITING.this.getBpelRuntime().writeEndpointReference(scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink), (Element)object);
                                    }
                                    if ((object = WAITING.this.getBpelRuntime().getSourceSessionId(string)) != null) {
                                        WAITING.this.getBpelRuntime().initializePartnersSessionId(scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink), (String)object);
                                    }
                                }
                            }
                            catch (FaultException faultException) {
                                __log.error((Object)faultException);
                                if (EH_EVENT.this._fault == null) {
                                    EH_EVENT.this._fault = WAITING.this.createFault(faultException.getQName(), EH_EVENT.this._oevent);
                                    EH_EVENT.this.terminateActive();
                                }
                                4.instance((JacobRunnable)new WAITING(null));
                                return;
                            }
                            object = new ActivityInfo(WAITING.this.genMonotonic(), ((EH_EVENT)EH_EVENT.this)._oevent.activity, (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
                            EH_EVENT.this._active.add(object);
                            serializable = new LinkFrame(null);
                            4.instance((JacobRunnable)new SCOPE((ActivityInfo)object, scopeFrame, (LinkFrame)serializable));
                            if (EH_EVENT.this._childrenTerminated) {
                                ((TerminationChannel)4.replication((Channel)((ActivityInfo)object).self)).terminate();
                            }
                            if (EH_EVENT.this._terminated || EH_EVENT.this._stopped || EH_EVENT.this._fault != null) {
                                4.instance((JacobRunnable)new WAITING(null));
                            } else {
                                4.instance((JacobRunnable)new SELECT());
                            }
                        }

                        public void onTimeout() {
                            4.instance((JacobRunnable)new WAITING(null));
                        }

                        public void onCancel() {
                            4.instance((JacobRunnable)new WAITING(null));
                        }
                    });
                }
                WAITING.object((boolean)false, hashSet);
            } else {
                EH_EVENT.this._psc.completed(EH_EVENT.this._fault, EH_EVENT.this._comps);
            }
        }
    }

    class SELECT
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 1L;

        SELECT() {
        }

        public void run() {
            try {
                CorrelationKey correlationKey;
                PickResponseChannel pickResponseChannel = (PickResponseChannel)this.newChannel(PickResponseChannel.class);
                PartnerLinkInstance partnerLinkInstance = EH_EVENT.this._scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.partnerLink);
                if (((EH_EVENT)EH_EVENT.this)._oevent.matchCorrelation == null) {
                    String string = this.getBpelRuntime().fetchMySessionId(partnerLinkInstance);
                    correlationKey = new CorrelationKey(-1, new String[]{string});
                } else {
                    if (!this.getBpelRuntime().isCorrelationInitialized(EH_EVENT.this._scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.matchCorrelation))) {
                        throw new FaultException(((EH_EVENT)EH_EVENT.this)._oevent.getOwner().constants.qnCorrelationViolation, "Correlation not initialized.");
                    }
                    correlationKey = this.getBpelRuntime().readCorrelation(EH_EVENT.this._scopeFrame.resolve(((EH_EVENT)EH_EVENT.this)._oevent.matchCorrelation));
                    assert (correlationKey != null);
                }
                Selector selector = new Selector(0, partnerLinkInstance, ((EH_EVENT)EH_EVENT.this)._oevent.operation.getName(), ((EH_EVENT)EH_EVENT.this)._oevent.operation.getOutput() == null, ((EH_EVENT)EH_EVENT.this)._oevent.messageExchangeId, correlationKey);
                this.getBpelRuntime().select(pickResponseChannel, null, false, new Selector[]{selector});
                SELECT.instance((JacobRunnable)new WAITING(pickResponseChannel));
            }
            catch (FaultException faultException) {
                __log.error((Object)faultException);
                if (EH_EVENT.this._fault == null) {
                    EH_EVENT.this._fault = this.createFault(faultException.getQName(), EH_EVENT.this._oevent);
                }
                EH_EVENT.this.terminateActive();
                SELECT.instance((JacobRunnable)new WAITING(null));
            }
        }
    }
}

