/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1.xpath10;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.dom.NodeWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.v1.EvaluationContext;
import org.apache.ode.bpel.rtrep.v1.OLink;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OVarType;
import org.apache.ode.bpel.rtrep.v1.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v1.OXslSheet;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v1.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v1.xpath10.WrappedFaultException;
import org.apache.ode.bpel.rtrep.v1.xpath10.XslRuntimeUriResolver;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.FunctionContext;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class JaxenContexts
implements FunctionContext,
VariableContext {
    private static final Log __log = LogFactory.getLog(JaxenContexts.class);
    private static final FunctionContext __defaultXPathFunctions = XPathFunctionContext.getInstance();
    private OXPath10Expression _oxpath;
    private EvaluationContext _xpathEvalCtx;
    private Function _getVariableProperty;
    private Function _getVariableData;
    private Function _getLinkStatus;
    private Function _doXslTransform;
    private Map _extensionFunctions;

    public JaxenContexts(OXPath10Expression oXPath10Expression, Map map, EvaluationContext evaluationContext) {
        this._oxpath = oXPath10Expression;
        this._xpathEvalCtx = evaluationContext;
        this._extensionFunctions = map;
        this._getVariableProperty = new BpelVariablePropertyFunction();
        this._getVariableData = new BpelVariableDataFunction();
        this._getLinkStatus = new GetLinkStatusFunction();
        this._doXslTransform = new DoXslTransformFunction();
    }

    public Function getFunction(String string, String string2, String string3) throws UnresolvableException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("getFunction(" + string + "," + string2 + "," + string3));
        }
        if (string != null) {
            OXPath10ExpressionBPEL20 oXPath10ExpressionBPEL20;
            QName qName = new QName(string, string3);
            if (qName.equals(this._oxpath.qname_getVariableProperty)) {
                return this._getVariableProperty;
            }
            if (qName.equals(this._oxpath.qname_getVariableData)) {
                return this._getVariableData;
            }
            if (qName.equals(this._oxpath.qname_getLinkStatus)) {
                return this._getLinkStatus;
            }
            if (this._oxpath instanceof OXPath10ExpressionBPEL20) {
                oXPath10ExpressionBPEL20 = (OXPath10ExpressionBPEL20)this._oxpath;
                if (qName.equals(oXPath10ExpressionBPEL20.qname_doXslTransform)) {
                    return this._doXslTransform;
                }
            }
            if ((oXPath10ExpressionBPEL20 = (Function)this._extensionFunctions.get(string3)) != null) {
                return oXPath10ExpressionBPEL20;
            }
        }
        return __defaultXPathFunctions.getFunction(null, string2, string3);
    }

    public Object getVariableValue(String string, String string2, String string3) throws UnresolvableException {
        String string4;
        String string5;
        if (!(this._oxpath instanceof OXPath10ExpressionBPEL20)) {
            throw new IllegalStateException("XPath variables not supported for bpel 1.1");
        }
        if ("ode".equals(string2) && "pid".equals(string3)) {
            return this._xpathEvalCtx.getProcessId();
        }
        OXPath10ExpressionBPEL20 oXPath10ExpressionBPEL20 = (OXPath10ExpressionBPEL20)this._oxpath;
        if (oXPath10ExpressionBPEL20.isJoinExpression) {
            OLink oLink = this._oxpath.links.get(string3);
            try {
                return this._xpathEvalCtx.isLinkActive(oLink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException faultException) {
                throw new WrappedFaultException.JaxenUnresolvableException(faultException);
            }
        }
        int n = string3.indexOf(46);
        if (n == -1) {
            string5 = string3;
            string4 = null;
        } else {
            string5 = string3.substring(0, n);
            string4 = string3.substring(n + 1);
        }
        OScope.Variable variable = this._oxpath.vars.get(string5);
        OMessageVarType.Part part = string4 == null ? null : ((OMessageVarType)variable.type).parts.get(string4);
        try {
            Node node = this._xpathEvalCtx.readVariable(variable, part);
            if (node == null) {
                throw new WrappedFaultException.JaxenUnresolvableException(new FaultException(variable.getOwner().constants.qnSelectionFailure, "Unknown variable " + string3));
            }
            OVarType oVarType = variable.type;
            if (oVarType instanceof OMessageVarType) {
                OMessageVarType.Part part2 = ((OMessageVarType)oVarType).parts.get(string4);
                if (part2 == null) {
                    throw new WrappedFaultException.JaxenUnresolvableException(new FaultException(variable.getOwner().constants.qnSelectionFailure, "Unknown part " + string4 + " for variable " + string3));
                }
                oVarType = part2.type;
            }
            if (this._xpathEvalCtx.narrowTypes() && oVarType instanceof OXsdTypeVarType && ((OXsdTypeVarType)oVarType).simple) {
                return node.getTextContent();
            }
            return node;
        }
        catch (FaultException faultException) {
            __log.error((Object)"bpws:getVariableValue threw FaultException", (Throwable)faultException);
            throw new WrappedFaultException.JaxenUnresolvableException(faultException);
        }
    }

    class DoXslTransformFunction
    implements Function {
        DoXslTransformFunction() {
        }

        public Object call(Context context, List list) throws FunctionCallException {
            Object object;
            Element element;
            Object object2;
            assert (list.size() >= 2);
            assert (list.size() % 2 == 0);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + context + " args=" + list + ")"));
            }
            if (!(JaxenContexts.this._oxpath instanceof OXPath10ExpressionBPEL20)) {
                throw new IllegalStateException("XPath function bpws:doXslTransform not supported in BPEL 1.1!");
            }
            try {
                if (list.get(1) instanceof List) {
                    object2 = (List)list.get(1);
                    if (object2.size() != 1) {
                        throw new WrappedFaultException.JaxenFunctionException(new FaultException(((JaxenContexts)JaxenContexts.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
                    }
                    element = (Element)object2.get(0);
                } else {
                    element = list.get(1) instanceof NodeWrapper ? (Element)((NodeWrapper)list.get(1)).getUnderlyingNode() : (Element)list.get(1);
                }
            }
            catch (ClassCastException classCastException) {
                throw new WrappedFaultException.JaxenFunctionException(new FaultException(((JaxenContexts)JaxenContexts.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            try {
                object2 = new URI((String)list.get(0));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new FunctionCallException("First parameter of the bpws:doXslTransform isn't a valid URI!", (Exception)uRISyntaxException);
            }
            OXslSheet oXslSheet = ((JaxenContexts)JaxenContexts.this)._oxpath.xslSheets.get(object2);
            if (oXslSheet == null) {
                throw new FunctionCallException("Couldn't find the XSL sheet " + list.get(0) + ", process compilation or deployment was probably incomplete!");
            }
            if (!(element instanceof Element)) {
                throw new WrappedFaultException.JaxenFunctionException(new FaultException(((JaxenContexts)JaxenContexts.this)._oxpath.getOwner().constants.qnXsltInvalidSource, "Second parameter of the bpws:doXslTransform function MUST point to a single element node."));
            }
            HashMap hashMap = null;
            if (list.size() > 2) {
                hashMap = new HashMap();
                for (int i = 2; i < list.size(); i += 2) {
                    object = ((JaxenContexts)JaxenContexts.this)._oxpath.namespaceCtx.derefQName((String)list.get(i));
                    hashMap.put((QName)object, list.get(i + 1));
                }
            }
            Document document = DOMUtils.newDocument();
            document.appendChild(document.importNode(element, true));
            DOMSource dOMSource = new DOMSource(document);
            XslRuntimeUriResolver xslRuntimeUriResolver = new XslRuntimeUriResolver(JaxenContexts.this._oxpath, JaxenContexts.this._xpathEvalCtx.getBaseResourceURI());
            XslTransformHandler.getInstance().cacheXSLSheet(JaxenContexts.this._xpathEvalCtx.getBaseResourceURI(), (URI)object2, oXslSheet.sheetBody, (URIResolver)xslRuntimeUriResolver);
            try {
                object = XslTransformHandler.getInstance().transform(JaxenContexts.this._xpathEvalCtx.getBaseResourceURI(), (URI)object2, (Source)dOMSource, hashMap, (URIResolver)xslRuntimeUriResolver);
            }
            catch (Exception exception) {
                throw new WrappedFaultException.JaxenFunctionException(new FaultException(((JaxenContexts)JaxenContexts.this)._oxpath.getOwner().constants.qnSubLanguageExecutionFault, exception.toString()));
            }
            return object;
        }
    }

    class GetLinkStatusFunction
    implements Function {
        GetLinkStatusFunction() {
        }

        public Object call(Context context, List list) throws FunctionCallException {
            assert (list.size() == 1);
            OLink oLink = ((JaxenContexts)JaxenContexts.this)._oxpath.links.get(list.get(0));
            try {
                return JaxenContexts.this._xpathEvalCtx.isLinkActive(oLink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException faultException) {
                __log.error((Object)("bpws:getLinkStatus(" + list + ") threw FaultException"), (Throwable)faultException);
                throw new WrappedFaultException.JaxenFunctionException(faultException);
            }
        }
    }

    class BpelVariablePropertyFunction
    implements Function {
        BpelVariablePropertyFunction() {
        }

        public Object call(Context context, List list) throws FunctionCallException {
            if (list.size() != 2) {
                throw new FunctionCallException("missing required arguments");
            }
            OScope.Variable variable = ((JaxenContexts)JaxenContexts.this)._oxpath.vars.get(list.get(0));
            OProcess.OProperty oProperty = ((JaxenContexts)JaxenContexts.this)._oxpath.properties.get(list.get(1));
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("function call:'bpws:getVariableProperty(" + variable + "," + oProperty + ")'"));
            }
            try {
                return JaxenContexts.this._xpathEvalCtx.readMessageProperty(variable, oProperty);
            }
            catch (FaultException faultException) {
                __log.error((Object)("bpws:getVariableProperty(" + list + ") threw FaultException"), (Throwable)faultException);
                throw new WrappedFaultException.JaxenFunctionException(faultException);
            }
        }
    }

    class BpelVariableDataFunction
    implements Function {
        BpelVariableDataFunction() {
        }

        public Object call(Context context, List list) throws FunctionCallException {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("call(context=" + context + " args=" + list + ")"));
            }
            String string = (String)list.get(0);
            String string2 = list.size() > 1 ? (String)list.get(1) : null;
            String string3 = list.size() > 2 ? (String)list.get(2) : null;
            OXPath10Expression.OSigGetVariableData oSigGetVariableData = JaxenContexts.this._oxpath.resolveGetVariableDataSig(string, string2, string3);
            if (oSigGetVariableData == null) {
                String string4 = "InternalError: Attempt to use an unknown getVariableData signature: " + list;
                if (__log.isFatalEnabled()) {
                    __log.fatal((Object)string4);
                }
                throw new FunctionCallException(string4);
            }
            try {
                Node node = JaxenContexts.this._xpathEvalCtx.readVariable(oSigGetVariableData.variable, oSigGetVariableData.part);
                if (oSigGetVariableData.location != null) {
                    node = JaxenContexts.this._xpathEvalCtx.evaluateQuery(node, oSigGetVariableData.location);
                }
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("bpws:getVariableData(" + list + ")' = " + node));
                }
                return node;
            }
            catch (FaultException faultException) {
                __log.error((Object)("bpws:getVariableData(" + list + ") threw FaultException"), (Throwable)faultException);
                throw new WrappedFaultException.JaxenFunctionException(faultException);
            }
        }
    }
}

