/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.performancecounters;

import java.util.Date;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgentBase;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.management.MeasureUnit;

public class ConnectivityPerformanceAgent
extends ConnectivityPerformanceAgentBase {
    private static final int BYTES_PER_KBYTE = 1024;
    private Date _startDate;
    private Date _endDate;
    private String _importRunId;
    private String _jobName;

    @MeasureUnit(value="KBytes/Second")
    public double getAverageAttachmentTransferRate() {
        return this.getAttachmentBytesTransfered().getNextSampleValue() / (double)this.getLastRunTime() * 1000.0 / 1024.0;
    }

    @MeasureUnit(value="ms")
    public double getOverallAverageDeltaIndicesProcessingTime() {
        return (double)this.getLastRunTime() / this.getDeltaIndices().getNextSampleValue();
    }

    @MeasureUnit(value="ms")
    public double getOverallAverageRecordsProcessingTime() {
        return (double)this.getLastRunTime() / this.getRecords().getNextSampleValue();
    }

    private long getLastRunTime() {
        if (this._startDate == null) {
            return 0L;
        }
        if (this._startDate != null && this._endDate == null) {
            return System.currentTimeMillis() - this._startDate.getTime();
        }
        return this._endDate.getTime() - this._startDate.getTime();
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public void setStartDate(Date date) {
        this._startDate = date;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public void setJobName(String jobName) {
        this._jobName = jobName;
    }

    public String getJobName() {
        return this._jobName;
    }

    public void setEndDate(Date endDate) {
        this._endDate = endDate;
    }

    public String getImportRunId() {
        return this._importRunId;
    }

    public void setImportRunId(String importRunId) {
        this._importRunId = importRunId;
    }

    public AnyMap toAny() {
        AnyMap any = DataFactory.DEFAULT.createAnyMap();
        any.put("jobName", this.getJobName());
        any.put("attachmentBytesTransfered", (Number)this.getAttachmentBytesTransfered().getNextSampleValue());
        any.put("attachmentTransferRate", (Number)this.getAttachmentTransferRate().getNextSampleValue());
        any.put("averageAttachmentTransferRate", (Number)this.getAverageAttachmentTransferRate());
        any.put("averageDeltaIndicesProcessingTime", (Number)this.getAverageDeltaIndicesProcessingTime().getNextSampleValue());
        any.put("averageRecordsProcessingTime", (Number)this.getAverageRecordsProcessingTime().getNextSampleValue());
        any.put("deltaIndices", (Number)this.getDeltaIndices().getNextSampleValue());
        if (this.getEndDate() != null) {
            any.put("endDate", (Any)DataFactory.DEFAULT.createDateTimeValue(this.getEndDate()));
        }
        any.put("errorBuffer", String.valueOf(this.getErrorBuffer().getErrors()));
        any.put("exceptions", (Number)this.getExceptions().getNextSampleValue());
        any.put("exceptionsCritical", (Number)this.getExceptionsCritical().getNextSampleValue());
        any.put("importRunId", this.getImportRunId());
        any.put("overallAverageDeltaIndicesProcessingTime", (Number)this.getOverallAverageDeltaIndicesProcessingTime());
        any.put("overallAverageRecordsProcessingTime", (Number)this.getOverallAverageRecordsProcessingTime());
        any.put("records", (Number)this.getRecords().getNextSampleValue());
        if (this.getStartDate() != null) {
            any.put("startDate", (Any)DataFactory.DEFAULT.createDateTimeValue(this.getStartDate()));
        }
        return any;
    }
}

