/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.search.api.helper.ResultItemAccessor;

public class ResultAccessor {
    protected final Record _result;
    private final String _workflowName;

    public ResultAccessor(String workflowName, Record result) {
        this._workflowName = workflowName;
        this._result = result;
    }

    public Record getResult() {
        return this._result;
    }

    public String getWorkflowName() {
        return this._workflowName;
    }

    public boolean hasQuery() {
        return this._result.getMetadata().containsKey((Object)"query");
    }

    public Any getQuery() {
        if (this.hasQuery()) {
            return (Any)this._result.getMetadata().get((Object)"query");
        }
        return null;
    }

    public long getCount() {
        return this.getLongProperty("count");
    }

    public long getIndexSize() {
        return this.getLongProperty("indexSize");
    }

    public long getRuntime() {
        return this.getLongProperty("runtime");
    }

    public AnyMap getGroups() {
        if (this._result.getMetadata().containsKey((Object)"groups")) {
            return this._result.getMetadata().getMap("groups");
        }
        return null;
    }

    private long getLongProperty(String name) {
        if (this._result.getMetadata().containsKey((Object)name)) {
            return this._result.getMetadata().getLongValue(name);
        }
        return 0L;
    }

    public boolean hasRecords() {
        return this._result.getMetadata().containsKey((Object)"records") && ((Any)this._result.getMetadata().get((Object)"records")).isSeq();
    }

    public AnySeq getResultRecords() {
        if (this.hasRecords()) {
            return this._result.getMetadata().getSeq("records");
        }
        return null;
    }

    public int getNumberOfRecords() {
        if (this.hasRecords()) {
            return this.getResultRecords().size();
        }
        return 0;
    }

    public ResultItemAccessor getResultRecord(int index) {
        if (index >= 0 && index < this.getNumberOfRecords()) {
            return new ResultItemAccessor(index, this.getResultRecords().getMap(index));
        }
        return null;
    }
}

