/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.input;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.input.Input;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.input.StreamInput;
import org.eclipse.smila.taskworker.io.IODataObject;
import org.eclipse.smila.taskworker.io.IODataObjects;

public class Inputs
extends IODataObjects {
    public Inputs(Map<String, List<BulkInfo>> dataObjects, ObjectStoreService objectStore) {
        super(dataObjects, objectStore);
    }

    public <T extends Input> T getAsInput(String slotName, Class<T> inputClass) {
        return this.getAsInput(slotName, 0, inputClass);
    }

    public <T extends Input> T getAsInput(String slotName, int index, Class<T> inputClass) {
        if (this.canCreate(slotName, index)) {
            BulkInfo dataObject = this.getDataObject(slotName, index);
            try {
                Constructor<T> inputConstructor = inputClass.getConstructor(BulkInfo.class, ObjectStoreService.class);
                Input input = (Input)inputConstructor.newInstance(dataObject, this.getObjectStore());
                this.putIOData(slotName, index, input);
                return (T)input;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Canot create instance of class " + inputClass, ex);
            }
        }
        return null;
    }

    public StreamInput getAsStreamInput(String slotName) {
        return this.getAsStreamInput(slotName, 0);
    }

    public StreamInput getAsStreamInput(String slotName, int index) {
        return this.getAsInput(slotName, index, StreamInput.class);
    }

    public RecordInput getAsRecordInput(String slotName) {
        return this.getAsRecordInput(slotName, 0);
    }

    public RecordInput getAsRecordInput(String slotName, int index) {
        return this.getAsInput(slotName, index, RecordInput.class);
    }

    public void closeAll() {
        Iterator<IODataObject[]> iterator = this.getIOData().values().iterator();
        while (iterator.hasNext()) {
            IODataObject[] inputs;
            IODataObject[] iODataObjectArray = inputs = iterator.next();
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                IODataObject input = iODataObjectArray[n2];
                if (input != null) {
                    ((Input)input).close();
                }
                ++n2;
            }
        }
    }

    public void addInputCounters(Map<String, Number> counters) {
        this.addCounters(counters, "input");
    }
}

