/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.Counters;
import org.eclipse.smila.taskworker.io.IODataObject;

public class IODataObjects {
    private final Map<String, List<BulkInfo>> _dataObjects;
    private final Map<String, IODataObject[]> _ioData = new HashMap<String, IODataObject[]>();
    private final ObjectStoreService _objectStore;

    public IODataObjects(Map<String, List<BulkInfo>> dataObjects, ObjectStoreService objectStore) {
        this._dataObjects = dataObjects;
        this._objectStore = objectStore;
    }

    public int getDataObjectCount(String slotName) {
        if (this._dataObjects.containsKey(slotName)) {
            return this._dataObjects.get(slotName).size();
        }
        return 0;
    }

    public BulkInfo getDataObject(String slotName) {
        return this.getDataObject(slotName, 0);
    }

    public BulkInfo getDataObject(String slotName, int index) {
        if (index < this.getDataObjectCount(slotName)) {
            return this._dataObjects.get(slotName).get(index);
        }
        return null;
    }

    public ObjectStoreService getObjectStore() {
        return this._objectStore;
    }

    protected boolean canCreate(String slotName, int index) {
        int dataObjectCount = this.getDataObjectCount(slotName);
        if (dataObjectCount > index) {
            IODataObject[] slot = this._ioData.get(slotName);
            if (slot == null) {
                slot = new IODataObject[dataObjectCount];
                this._ioData.put(slotName, slot);
            }
            return slot[index] == null;
        }
        return false;
    }

    protected void putIOData(String slotName, int index, IODataObject ioData) {
        IODataObject[] slotInputs = this._ioData.get(slotName);
        slotInputs[index] = ioData;
    }

    protected Map<String, IODataObject[]> getIOData() {
        return this._ioData;
    }

    public void addCounters(Map<String, Number> counters, String name) {
        String durationPerformName = "duration.perform." + name;
        for (Map.Entry<String, IODataObject[]> slots : this._ioData.entrySet()) {
            String slotName = slots.getKey();
            String prefix = String.valueOf(name) + "." + slotName;
            IODataObject[] iODataObjectArray = slots.getValue();
            int n = iODataObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IODataObject io = iODataObjectArray[n2];
                if (io != null) {
                    long durationPerform;
                    long durationOpen = io.getDurationOpen();
                    if (durationOpen > 0L) {
                        Counters.addDuration(counters, "duration.iodata.open", io.getDurationOpen());
                    }
                    if ((durationPerform = io.getDurationPerform()) > 0L) {
                        Counters.addDuration(counters, durationPerformName, durationPerform);
                        Counters.addDuration(counters, String.valueOf(durationPerformName) + "." + slotName, durationPerform);
                    }
                    Counters.addAll(counters, io.getCounter(), prefix);
                }
                ++n2;
            }
        }
    }
}

