/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.utils.config.ConfigurationLoadException;
import org.osgi.framework.Bundle;

public final class ConfigUtils {
    public static final String PROPERTY_CONFIG_ROOT = "org.eclipse.smila.utils.config.root";
    private static final String CONFIGURATION_FOLDER_NAME = "configuration/";
    private static final String[] PRIOTIZED_PATHS = new String[]{System.getProperty("org.eclipse.smila.utils.config.root"), System.getenv("org.eclipse.smila.utils.config.root"), String.valueOf(Platform.getInstallLocation().getURL().getFile()) + "configuration/"};
    private static final File CONFIGURATION_FOLDER = ConfigUtils.determineFolder();

    private ConfigUtils() {
    }

    private static File determineFolder() {
        Log log = LogFactory.getLog(ConfigUtils.class);
        File file = null;
        String[] stringArray = PRIOTIZED_PATHS;
        int n = PRIOTIZED_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (StringUtils.isNotBlank((String)path)) {
                file = new File(path);
                break;
            }
            ++n2;
        }
        if (file != null) {
            if (file.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("CONFIGURATION_FOLDER = " + file.getAbsolutePath()));
                } else {
                    System.out.println("CONFIGURATION_FOLDER = " + file.getAbsolutePath());
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("CONFIGURATION_FOLDER ( " + file.getAbsolutePath() + " ) is not found"));
                } else {
                    System.out.println("CONFIGURATION_FOLDER ( " + file.getAbsolutePath() + " ) is not found");
                }
                file = null;
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"No CONFIGURATION_FOLDER is found");
        } else {
            System.out.println("No CONFIGURATION_FOLDER is found");
        }
        return file;
    }

    public static InputStream getConfigStream(String bundleName, String configPath, String defaultConfigPath) {
        File bundleConfigRoot;
        String effectivePath = "CONFIGURATION_FOLDER" + File.separator + new File(bundleName, configPath).getPath();
        if (ConfigUtils.getConfigurationFolder() != null && (bundleConfigRoot = new File(ConfigUtils.getConfigurationFolder(), bundleName)).exists()) {
            File configFile = new File(configPath);
            File effectiveConfigFile = configFile.isAbsolute() ? configFile : new File(bundleConfigRoot, configPath);
            effectivePath = effectiveConfigFile.getAbsolutePath();
            if (effectiveConfigFile.exists()) {
                try {
                    return new FileInputStream(effectiveConfigFile);
                }
                catch (Exception exception) {
                    throw new ConfigurationLoadException("Failed to open config file: " + effectivePath);
                }
            }
        }
        if (defaultConfigPath == null) {
            throw new ConfigurationLoadException(String.format("Configuration resource %s for the bundle %s not found", configPath, bundleName));
        }
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ConfigurationLoadException("Unable to find bundle: " + bundleName);
        }
        URL url = bundle.getEntry(defaultConfigPath);
        if (url == null) {
            throw new ConfigurationLoadException(String.format("Unable to find config file '%s' nor fallback config '%s' in bundle '%s'", effectivePath, defaultConfigPath, bundleName));
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new ConfigurationLoadException(e);
        }
    }

    @Deprecated
    public static File getConfigFolder(String bundleName, String configPath) {
        return ConfigUtils.getConfigFile(bundleName, configPath);
    }

    public static File getConfigFile(String bundleName, String configPath) {
        File file;
        if (CONFIGURATION_FOLDER != null && (file = new File(CONFIGURATION_FOLDER, bundleName)).exists() && (file = new File(file, configPath)).exists()) {
            return file;
        }
        return null;
    }

    public static File getConfigFilePath(String bundleName, String configPath) {
        return new File(new File(CONFIGURATION_FOLDER, bundleName), configPath);
    }

    public static InputStream getConfigStream(String bundleName, String configPath) {
        return ConfigUtils.getConfigStream(bundleName, configPath, configPath);
    }

    public static List<String> getConfigEntries(String bundleName, String configPath) {
        File file;
        if (ConfigUtils.getConfigurationFolder() != null && (file = new File(ConfigUtils.getConfigurationFolder(), bundleName)).exists() && (file = new File(file, configPath)).exists()) {
            if (!file.isDirectory()) {
                throw new ConfigurationLoadException("configPath does not denote a directory: " + file.getAbsolutePath());
            }
            String[] files = file.list();
            return Arrays.asList(files);
        }
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ConfigurationLoadException("Unable to fing bundle " + bundleName);
        }
        try {
            ArrayList<String> entries = new ArrayList<String>();
            Enumeration paths = bundle.getEntryPaths(configPath);
            while (paths.hasMoreElements()) {
                entries.add((String)paths.nextElement());
            }
            return entries;
        }
        catch (Exception exception) {
            throw new ConfigurationLoadException(String.format("Unable to find configuration resource %s in the bundle %s", configPath, bundleName));
        }
    }

    public static File getConfigurationFolder() {
        return CONFIGURATION_FOLDER;
    }

    public static Properties getConfigProperties(String bundleName, String configPath) throws IOException {
        Properties properties = new Properties();
        InputStream configStream = ConfigUtils.getConfigStream(bundleName, configPath);
        try {
            properties.load(configStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)configStream);
        }
        return properties;
    }

    public static String getConfigContent(String bundleName, String configPath) throws IOException {
        InputStream configStream = ConfigUtils.getConfigStream(bundleName, configPath);
        try {
            String string = IOUtils.toString((InputStream)configStream, (String)"utf-8");
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)configStream);
        }
    }
}

