/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.scriptexecution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.smila.utils.scriptexecution.ScriptExecutor;
import org.eclipse.smila.utils.scriptexecution.UnixScriptExecutor;
import org.eclipse.smila.utils.scriptexecution.WindowsScriptExecutor;

public final class ScriptExecutorFactory {
    private ScriptExecutorFactory() {
    }

    public static ScriptExecutor getScriptExecutor() {
        Log log = LogFactory.getLog(ScriptExecutorFactory.class);
        String platform = Platform.getOS();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting script executor for " + platform));
        }
        if ("win32".equals(platform)) {
            return new WindowsScriptExecutor();
        }
        if ("linux".equals(platform) || "solaris".equals(platform)) {
            return new UnixScriptExecutor();
        }
        throw new IllegalStateException("Valid script executor is missing for [" + platform + "] platform.");
    }
}

