/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Peter Wissel (brox IT Solutions GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.solr.search;

import org.apache.solr.common.params.CommonParams;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.search.api.helper.QueryParameterAccessor;
import org.eclipse.smila.solr.SolrConstants;

/**
 * The SolrQueryParameterAccessor.
 * 
 * @author pwissel
 * 
 */
public class SolrQueryParameterAccessor extends QueryParameterAccessor {

  /**
   * Constructor.
   * 
   * @param blackboard
   *          the blackboard.
   * @param queryRecordId
   *          the query record id.
   * @throws BlackboardAccessException
   */
  public SolrQueryParameterAccessor(final Blackboard blackboard, final String queryRecordId)
    throws BlackboardAccessException {
    super(blackboard, queryRecordId);
  }

  /**
   * Constructor.
   * 
   * @param blackboard
   *          the blackboard.
   * @param configuration
   *          the configuration.
   * @param queryRecordId
   *          the query record id.
   * @throws BlackboardAccessException
   */
  public SolrQueryParameterAccessor(final Blackboard blackboard, final AnyMap configuration,
    final String queryRecordId) throws BlackboardAccessException {
    super(blackboard, configuration, queryRecordId);
  }

  /**
   * Get request handler.
   * 
   * @return the request handler or null.
   */
  public String getRequestHandler() {
    return getSolrQueryParams().getStringValue(CommonParams.QT);
  }

  /**
   * Get highlighting.
   * 
   * @return the highlighting sequence or null.
   */
  public AnySeq getHighlighting() {
    return getSolrQueryParams().getSeq(SolrConstants.HIGHLIGHTING);
  }

  /**
   * Get terms.
   * 
   * @return the term map or null.
   */
  public AnyMap getTerms() {
    return getSolrQueryParams().getMap(SolrConstants.TERMS);
  }

  /**
   * Get filter query.
   * 
   * @return the filter query sequence or null.
   */
  public AnySeq getFilterQuery() {
    return getSolrQueryParams().getSeq(SolrConstants.FILTER_QUERY);
  }

  /**
   * Get shards.
   * 
   * @return the shards seq or null.
   */
  public AnySeq getShards() {
    return getSolrQueryParams().getSeq(SolrConstants.SHARDS);
  }

  /**
   * Get spellcheck.
   * 
   * @return the spellcheck map or null.
   */
  public AnyMap getSpellcheck() {
    return getSolrQueryParams().getMap(SolrConstants.SPELLCHECK);
  }

  public AnyMap getSolrQueryParams() {
    try {
      /*
       * NOTE: at the moment we always must go thru the BB to get to the stuff , otherwise the stest fail| tmenzel @ Jul
       * 14, 2011
       */
      final AnyMap _metadata = _blackboard.getMetadata(_recordId);
      final AnyMap _solrQueryParams = _metadata.getMap(SolrConstants.QUERY_MAP);

      // if (_metadata == null) {
      // _metadata = _blackboard.getMetadata(_recordId);
      // } else {
      // return AnyMap.EMPTY;
      // }
      //
      // if (_solrQueryParams == null) {
      // _solrQueryParams = _metadata.getMap(SolrConstants.QUERY_MAP);
      // } else {
      // return AnyMap.EMPTY;
      // }

      return _solrQueryParams == null ? AnyUtil.EMPTY_MAP : _solrQueryParams;
    } catch (BlackboardAccessException e) {
      throw new RuntimeException(e);
    }
  }
}
