/***********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ProcessingConstants;
import org.eclipse.smila.processing.util.ResultCollector;

/**
 * @author aweber
 */
public class AddValuesPipelet implements Pipelet {

  /** config property name for attribute name to add values to. */
  private static final String PARAM_ATTRIBUTE = "outputAttribute";

  /** config property name for the values to add. */
  private static final String PARAM_VALUES = "valuesToAdd";

  /** the pipelet's configuration. */
  private AnyMap _config;

  /** local logger. */
  private final Log _log = LogFactory.getLog(getClass());

  /**
   * add Any values to an attribute as described in pipelet config or parameters.
   * 
   * {@inheritDoc}
   */
  @Override
  public String[] process(final Blackboard blackboard, final String[] recordIds) throws ProcessingException {
    final ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, _config);
    final ResultCollector resultCollector =
      new ResultCollector(paramAccessor, _log, ProcessingConstants.DROP_ON_ERROR_DEFAULT);
    for (final String id : recordIds) {
      paramAccessor.setCurrentRecord(id);
      // the attribute to which to add the values.
      final String outputAttribute = paramAccessor.getParameter(PARAM_ATTRIBUTE, null);
      // the values to add.
      final Any values = paramAccessor.getParameterAny(PARAM_VALUES);
      if (values != null && outputAttribute != null) {
        try {
          for (final Any value : values) {
            blackboard.getMetadata(id).add(outputAttribute, value);
          }
          resultCollector.addResult(id);
        } catch (final Exception ex) {
          resultCollector.addFailedResult(id, ex);
        }
      }
    }
    return resultCollector.getResultIds();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void configure(final AnyMap configuration) throws ProcessingException {
    _config = configuration;
  }

}
