/***********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the 
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial creator
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework;

/**
 * thrown to describe situations in which it does not make sense for an agent to continue operation.
 */
public class AgentCriticalException extends Exception {

  /**
   * The Constant serialVersionUID.
   */
  private static final long serialVersionUID = 1L;

  /**
   * create new instance with message.
   */
  public AgentCriticalException(final String message) {
    super(message);
  }

  /**
   * create new instance with cause.
   */
  public AgentCriticalException(final Throwable cause) {
    super(cause);
  }

  /**
   * create new instance with message and cause.
   */
  public AgentCriticalException(final String message, final Throwable cause) {
    super(message, cause);
  }

}
