/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Ivan Churkin (brox IT Solutions GmbH) - initial creator
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.performancecounters;

import java.util.Date;

import org.eclipse.smila.connectivity.framework.CrawlerController;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementAgentNotFoundException;
import org.eclipse.smila.management.ManagementRegistration;

/**
 * The Class CrawlerControllerPerformanceCounterHelper.
 */
public class CrawlerControllerPerformanceCounterHelper extends
  ConnectivityPerformanceCounterHelperBase<ConnectivityPerformanceAgent> {

  /**
   * Instantiates a new crawler controller performance counter helper.
   * 
   * @param configuration
   *          the configuration
   * @param hashCode
   *          the hash code
   */
  public CrawlerControllerPerformanceCounterHelper(final DataSourceConnectionConfig configuration,
    final int hashCode) {
    super(configuration, hashCode, ConnectivityPerformanceAgent.class);
  }

  /** {@inheritDoc} */
  @Override
  protected String getPerformanceAgentLocation() {
    return CrawlerController.PERFORMANCE_AGENT_LOCATION;
  }

  /** {@inheritDoc} */
  @Override
  protected String getPerformanceAgentCategory() {
    return "Crawlers";
  }

  /** {@inheritDoc} */
  @Override
  protected String getdateConnectionIdSuffix() {
    return "Crawler";
  }

  /**
   * Inits the agent.
   * 
   * @param location
   *          the location
   * 
   * @return the agent type
   */
  @Override
  protected ConnectivityPerformanceAgent initAgent(final ManagementAgentLocation location) {
    synchronized (ManagementRegistration.INSTANCE.getMonitor()) {
      try {
        return (ConnectivityPerformanceAgent) ManagementRegistration.INSTANCE.getAgent(location);
      } catch (final ManagementAgentNotFoundException e) {
        // TODO: tests does not init it correctly
        _log.warn(String.format("Agent location [%s] is not found", location));
        // throw new RuntimeException(e);
        return null;
      } catch (final Throwable e) {
        // TODO: tests does not init it correctly
        _log.warn(String.format("Agent location [%s] is not initialized", location));
        // throw new RuntimeException(e);
        return null;
      }

    }
  }

  /**
   * sets the crawler start date.
   * 
   * @param date
   *          the start date
   * @deprecated use setStartDate instead.
   */
  @Deprecated
  public void setCrawlerStartDate(final Date date) {
    super.setStartDate(date);
  }

  /**
   * sets the crawler end date.
   * 
   * @param date
   *          the end date
   * @deprecated use setEndDate instead.
   */
  @Deprecated
  public void setCrawlerEndDate(final Date date) {
    super.setEndDate(date);
  }

}
