/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.internal.AccessAny;
import org.eclipse.smila.jobmanager.util.ValueExpression;

/**
 * Container for data object type mode data.
 */
class DataObjectTypeModeDefinition {

  /** Property for object in json. */
  public static final String OBJECT = "object";

  /** Property for store in json. */
  public static final String STORE = "store";

  /** The object of the data object type definition (mandatory). */
  private ValueExpression _object;

  /** The store of the data object type definition. */
  private ValueExpression _store;

  /**
   * @param modeDefAny
   *          input object
   * @throws InvalidConfigException
   *           if the input object is not filled with all desired values
   */
  public DataObjectTypeModeDefinition(final AnyMap modeDefAny) throws InvalidConfigException {
    setObject(AccessAny.getValueExpressionRequired(modeDefAny, OBJECT));
    setStore(AccessAny.getValueExpressionRequired(modeDefAny, STORE));
  }

  /**
   * Returns this object as an Any representation.
   * 
   * @return Any object describing this object
   */
  public Any toAny() {
    try {
      final AnyMap defAny = AccessAny.FACTORY.createAnyMap();
      defAny.put(OBJECT, _object.toString());
      defAny.put(STORE, _store.toString());
      return defAny;
    } catch (final Exception ex) {
      throw new IllegalStateException("Failed to create Any object for data object type mode", ex);
    }
  }

  /**
   * @return the object
   */
  public ValueExpression getObject() {
    return _object;
  }

  /**
   * @param object
   *          the object to set
   */
  public void setObject(final ValueExpression object) {
    _object = object;
  }

  /**
   * @return the store
   */
  public ValueExpression getStore() {
    return _store;
  }

  /**
   * @param store
   *          the store to set
   */
  public void setStore(final ValueExpression store) {
    _store = store;
  }
}
