/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitOfWorkChangeSet
implements Serializable,
org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet {
    protected transient Hashtable objectChanges;
    protected transient Hashtable newObjectChangeSets;
    protected transient Map cloneToObjectChangeSet;
    protected transient Map objectChangeSetToUOWClone;
    protected Map aggregateList;
    protected Map allChangeSets;
    protected Map deletedObjects;
    protected boolean hasChanges;
    protected boolean hasForcedChanges;
    private boolean isChangeSetFromOutsideUOW = false;

    public UnitOfWorkChangeSet() {
        this.setHasChanges(false);
    }

    public UnitOfWorkChangeSet(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
        ObjectInputStream objectIn = new ObjectInputStream(byteIn);
        this.allChangeSets = (Map)objectIn.readObject();
        this.deletedObjects = (Map)objectIn.readObject();
    }

    public void addDeletedObjects(Map deletedObjects, AbstractSession session) {
        for (Object object : deletedObjects.keySet()) {
            this.addDeletedObject(object, session);
        }
    }

    public void addDeletedObject(Object object, AbstractSession session) {
        ClassDescriptor descriptor = session.getDescriptor(object);
        if (!descriptor.isAggregateCollectionDescriptor()) {
            ObjectChangeSet set = descriptor.getObjectBuilder().createObjectChangeSet(object, this, false, session);
            set.setShouldBeDeleted(true);
            this.getDeletedObjects().put(set, set);
        }
    }

    public void addObjectChangeSet(ObjectChangeSet objectChanges, AbstractSession session, boolean forceToNewObjectList) {
        if (objectChanges != null) {
            if (objectChanges.isNew() && forceToNewObjectList) {
                this.addNewObjectChangeSet(objectChanges, session);
                this.getAllChangeSets().put(objectChanges, objectChanges);
            } else {
                boolean objectChangeSetHasChanges = objectChanges.hasChanges();
                if (objectChangeSetHasChanges) {
                    this.setHasChanges(true);
                    this.hasForcedChanges = this.hasForcedChanges || objectChanges.hasForcedChanges();
                } else {
                    this.hasForcedChanges = true;
                }
                if (!objectChanges.isAggregate()) {
                    if (objectChangeSetHasChanges) {
                        this.getAllChangeSets().put(objectChanges, objectChanges);
                    }
                    if (objectChanges.getCacheKey() != null) {
                        Hashtable<ObjectChangeSet, ObjectChangeSet> table = (Hashtable<ObjectChangeSet, ObjectChangeSet>)this.getObjectChanges().get(objectChanges.getClassName());
                        if (table == null) {
                            table = new Hashtable<ObjectChangeSet, ObjectChangeSet>(2);
                            this.getObjectChanges().put(objectChanges.getClassName(), table);
                            table.put(objectChanges, objectChanges);
                        } else {
                            table.put(objectChanges, objectChanges);
                        }
                    }
                }
            }
        }
    }

    protected void addNewObjectChangeSet(ObjectChangeSet objectChanges, AbstractSession session) {
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> changeSetTable = (IdentityHashMap<ObjectChangeSet, ObjectChangeSet>)this.getNewObjectChangeSets().get(objectChanges.getClassType(session));
        if (changeSetTable == null) {
            changeSetTable = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
            this.getNewObjectChangeSets().put(objectChanges.getClassType(session), changeSetTable);
        }
        changeSetTable.put(objectChanges, objectChanges);
    }

    public ObjectChangeSet findObjectChangeSet(ObjectChangeSet changeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        Hashtable changes = (Hashtable)this.getObjectChanges().get(changeSet.getClassName());
        ObjectChangeSet potential = null;
        if (changes != null) {
            potential = (ObjectChangeSet)changes.get(changeSet);
        }
        if (potential == null) {
            potential = (ObjectChangeSet)this.getObjectChangeSetForClone(changeSet.getUnitOfWorkClone());
        }
        return potential;
    }

    public ObjectChangeSet findOrIntegrateObjectChangeSet(ObjectChangeSet tofind, UnitOfWorkChangeSet mergeFromChangeSet) {
        if (tofind == null) {
            return tofind;
        }
        ObjectChangeSet localChangeSet = this.findObjectChangeSet(tofind, mergeFromChangeSet);
        if (localChangeSet == null) {
            localChangeSet = new ObjectChangeSet(tofind.getPrimaryKeys(), tofind.getClassType(), tofind.getUnitOfWorkClone(), this, tofind.isNew());
            this.addObjectChangeSetForIdentity(localChangeSet, localChangeSet.getUnitOfWorkClone());
        }
        return localChangeSet;
    }

    public void addObjectChangeSetForIdentity(ObjectChangeSet objectChanges, Object object) {
        if (objectChanges == null || object == null) {
            return;
        }
        if (objectChanges.isAggregate()) {
            this.getAggregateList().put(objectChanges, objectChanges);
        }
        this.getObjectChangeSetToUOWClone().put(objectChanges, object);
        this.getCloneToObjectChangeSet().put(object, objectChanges);
    }

    protected Map getAggregateList() {
        if (this.aggregateList == null) {
            this.aggregateList = new IdentityHashMap();
        }
        return this.aggregateList;
    }

    @Override
    public Map getAllChangeSets() {
        if (this.allChangeSets == null) {
            this.allChangeSets = new IdentityHashMap();
        }
        return this.allChangeSets;
    }

    public byte[] getByteArrayRepresentation(AbstractSession session) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> writableChangeSets = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
        for (ObjectChangeSet changeSet : this.getAllChangeSets().values()) {
            ClassDescriptor descriptor = session.getDescriptor(changeSet.getClassType(session));
            int syncType = descriptor.getCacheSynchronizationType();
            if (changeSet.isNew() && syncType != 3) continue;
            changeSet.setSynchronizationType(syncType);
            changeSet.prepareChangeRecordsForSynchronization(session);
            writableChangeSets.put(changeSet, changeSet);
        }
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> sendableDeletedObjects = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
        for (ObjectChangeSet changeSet : this.getDeletedObjects().keySet()) {
            ClassDescriptor descriptor = session.getDescriptor(changeSet.getClassType(session));
            int syncType = descriptor.getCacheSynchronizationType();
            if (syncType == 4) continue;
            changeSet.setSynchronizationType(syncType);
            changeSet.prepareChangeRecordsForSynchronization(session);
            sendableDeletedObjects.put(changeSet, changeSet);
        }
        if (writableChangeSets.isEmpty() && sendableDeletedObjects.isEmpty()) {
            return null;
        }
        objectOut.writeObject(writableChangeSets);
        objectOut.writeObject(sendableDeletedObjects);
        return byteOut.toByteArray();
    }

    public Map getCloneToObjectChangeSet() {
        if (this.cloneToObjectChangeSet == null) {
            this.cloneToObjectChangeSet = new IdentityHashMap();
        }
        return this.cloneToObjectChangeSet;
    }

    @Override
    public Map getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new IdentityHashMap();
        }
        return this.deletedObjects;
    }

    public Hashtable getObjectChanges() {
        if (this.objectChanges == null) {
            this.objectChanges = new Hashtable(2);
        }
        return this.objectChanges;
    }

    public Set<Class> findUpdatedObjectsClasses() {
        if (this.objectChanges == null || this.objectChanges.isEmpty()) {
            return null;
        }
        HashSet<Class> updatedObjectsClasses = new HashSet<Class>(this.getObjectChanges().size());
        block0: for (Hashtable table : this.getObjectChanges().values()) {
            for (ObjectChangeSet changeSet : table.keySet()) {
                if (changeSet.isNew()) continue;
                updatedObjectsClasses.add(changeSet.getClassType());
                continue block0;
            }
        }
        return updatedObjectsClasses;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.ObjectChangeSet getObjectChangeSetForClone(Object clone) {
        if (clone == null || this.getCloneToObjectChangeSet() == null) {
            return null;
        }
        return (org.eclipse.persistence.sessions.changesets.ObjectChangeSet)this.getCloneToObjectChangeSet().get(clone);
    }

    protected Map getObjectChangeSetToUOWClone() {
        if (this.objectChangeSetToUOWClone == null) {
            this.objectChangeSetToUOWClone = new IdentityHashMap();
        }
        return this.objectChangeSetToUOWClone;
    }

    @Override
    public Object getUOWCloneForObjectChangeSet(org.eclipse.persistence.sessions.changesets.ObjectChangeSet changeSet) {
        if (changeSet == null || this.getObjectChangeSetToUOWClone() == null) {
            return null;
        }
        return this.getObjectChangeSetToUOWClone().get(changeSet);
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges || !this.getDeletedObjects().isEmpty();
    }

    public void setHasChanges(boolean flag) {
        this.hasChanges = flag;
    }

    public boolean hasForcedChanges() {
        return this.hasForcedChanges;
    }

    public ObjectChangeSet mergeObjectChanges(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        ObjectChangeSet localChangeSet = this.findOrIntegrateObjectChangeSet(objectChangeSet, mergeFromChangeSet);
        if (localChangeSet != null) {
            localChangeSet.mergeObjectChanges(objectChangeSet, this, mergeFromChangeSet);
        }
        return localChangeSet;
    }

    public void mergeUnitOfWorkChangeSet(UnitOfWorkChangeSet mergeFromChangeSet, AbstractSession session, boolean postCommit) {
        for (Hashtable table : mergeFromChangeSet.getObjectChanges().values()) {
            for (ObjectChangeSet objectChangeSet : table.values()) {
                objectChangeSet = this.mergeObjectChanges(objectChangeSet, mergeFromChangeSet);
                this.addObjectChangeSet(objectChangeSet, session, !postCommit);
            }
        }
        for (ObjectChangeSet objectChangeSet : mergeFromChangeSet.getDeletedObjects().values()) {
            ObjectChangeSet localObjectChangeSet = this.findObjectChangeSet(objectChangeSet, mergeFromChangeSet);
            if (localObjectChangeSet == null) {
                localObjectChangeSet = objectChangeSet;
            }
            this.getDeletedObjects().put(localObjectChangeSet, localObjectChangeSet);
        }
    }

    public void putNewObjectInChangesList(ObjectChangeSet objectChangeSet, AbstractSession session) {
        this.addObjectChangeSet(objectChangeSet, session, false);
        this.removeObjectChangeSetFromNewList(objectChangeSet, session);
    }

    public void removeObjectChangeSetFromNewList(ObjectChangeSet objectChangeSet, AbstractSession session) {
        Map table = (Map)this.getNewObjectChangeSets().get(objectChangeSet.getClassType(session));
        if (table != null) {
            table.remove(objectChangeSet);
        }
    }

    public void removeObjectChangeSet(ObjectChangeSet objectChanges) {
        if (objectChanges == null) {
            return;
        }
        Object object = this.getObjectChangeSetToUOWClone().get(objectChanges);
        if (objectChanges.isAggregate()) {
            this.getAggregateList().remove(objectChanges);
        } else {
            Hashtable table = (Hashtable)this.getObjectChanges().get(object.getClass().getName());
            if (table != null) {
                table.remove(objectChanges);
            }
        }
        this.getObjectChangeSetToUOWClone().remove(objectChanges);
        if (object != null) {
            this.getCloneToObjectChangeSet().remove(object);
        }
        this.getAllChangeSets().remove(objectChanges);
    }

    public void setIsChangeSetFromOutsideUOW(boolean isChangeSetFromOutsideUOW) {
        this.isChangeSetFromOutsideUOW = isChangeSetFromOutsideUOW;
    }

    public boolean isChangeSetFromOutsideUOW() {
        return this.isChangeSetFromOutsideUOW;
    }

    protected void setCloneToObjectChangeSet(Map newCloneToObjectChangeSet) {
        this.cloneToObjectChangeSet = newCloneToObjectChangeSet;
    }

    protected void setObjectChanges(Hashtable objectChanges) {
        this.objectChanges = objectChanges;
    }

    protected void setObjectChangeSetToUOWClone(Map newObjectChangeSetToUOWClone) {
        this.objectChangeSetToUOWClone = newObjectChangeSetToUOWClone;
    }

    public Hashtable getNewObjectChangeSets() {
        if (this.newObjectChangeSets == null) {
            this.newObjectChangeSets = new Hashtable();
        }
        return this.newObjectChangeSets;
    }

    public void setInternalAllChangeSets(Vector objectChangeSets) {
        if (objectChangeSets == null) {
            return;
        }
        for (int i = 0; i < objectChangeSets.size(); ++i) {
            ObjectChangeSet objChangeSet = (ObjectChangeSet)objectChangeSets.elementAt(i);
            objChangeSet.setUOWChangeSet(this);
            if (objChangeSet.isAggregate()) {
                this.getAggregateList().put(objChangeSet, objChangeSet);
            } else if (objChangeSet.shouldBeDeleted()) {
                this.getDeletedObjects().put(objChangeSet, objChangeSet);
            } else {
                this.getAllChangeSets().put(objChangeSet, objChangeSet);
            }
            if (objChangeSet.getCacheKey() == null) continue;
            Hashtable<ObjectChangeSet, ObjectChangeSet> table = (Hashtable<ObjectChangeSet, ObjectChangeSet>)this.getObjectChanges().get(objChangeSet.getClassName());
            if (table == null) {
                table = new Hashtable<ObjectChangeSet, ObjectChangeSet>(2);
                this.getObjectChanges().put(objChangeSet.getClassName(), table);
            }
            table.put(objChangeSet, objChangeSet);
        }
    }
}

