/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.rtrep.v1.PartnerLinkInstance;
import org.apache.ode.bpel.rtrep.v1.Selector;
import org.apache.ode.utils.ObjectPrinter;

class OutstandingRequestManager
implements Serializable {
    private static final long serialVersionUID = -5556374398943757951L;
    private static final Log __log = LogFactory.getLog(OutstandingRequestManager.class);
    private final Map<RequestIdTuple, Entry> _byRid = new HashMap<RequestIdTuple, Entry>();
    private final Map<String, Entry> _byChannel = new HashMap<String, Entry>();

    OutstandingRequestManager() {
    }

    int findConflict(Selector[] selectorArray) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"findConflict", (Object[])new Object[]{"selectors", selectorArray}));
        }
        HashSet<RequestIdTuple> hashSet = new HashSet<RequestIdTuple>(this._byRid.keySet());
        for (int i = 0; i < selectorArray.length; ++i) {
            if (selectorArray[i].oneWay) continue;
            RequestIdTuple requestIdTuple = new RequestIdTuple(selectorArray[i].plinkInstance, selectorArray[i].opName, selectorArray[i].messageExchangeId);
            if (hashSet.contains(requestIdTuple)) {
                return i;
            }
            hashSet.add(requestIdTuple);
        }
        return -1;
    }

    void register(String string, Selector[] selectorArray) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"register", (Object[])new Object[]{"pickResponseChannel", string, "selectors", selectorArray}));
        }
        if (this._byChannel.containsKey(string)) {
            String string2 = "INTERNAL ERROR: Duplicate ENTRY for RESPONSE CHANNEL " + string;
            __log.fatal((Object)string2);
            throw new IllegalArgumentException(string2);
        }
        Entry entry = new Entry(string, selectorArray);
        for (Selector selector : selectorArray) {
            if (selector.oneWay) continue;
            RequestIdTuple requestIdTuple = new RequestIdTuple(selector.plinkInstance, selector.opName, selector.messageExchangeId);
            if (this._byRid.containsKey(requestIdTuple)) {
                String string3 = "INTERNAL ERROR: Duplicate ENTRY for RID " + requestIdTuple;
                __log.fatal((Object)string3);
                throw new IllegalStateException(string3);
            }
            this._byRid.put(requestIdTuple, entry);
        }
        this._byChannel.put(string, entry);
    }

    void cancel(String string) {
        Entry entry;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"cancel", (Object[])new Object[]{"pickResponseChannel", string}));
        }
        if ((entry = this._byChannel.remove(string)) != null) {
            this._byRid.values().remove(entry);
        }
    }

    void associate(String string, String string2) {
        Entry entry;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"associate", (Object[])new Object[]{"pickResponseChannel", string, "mexRef", string2}));
        }
        if ((entry = this._byChannel.get(string)) == null) {
            String string3 = "INTERNAL ERROR: No ENTRY for RESPONSE CHANNEL " + string;
            __log.fatal((Object)string3);
            throw new IllegalArgumentException(string3);
        }
        if (entry.mexRef != null) {
            String string4 = "INTERNAL ERROR: Duplicate ASSOCIATION for CHANEL " + string;
            __log.fatal((Object)string4);
            throw new IllegalStateException(string4);
        }
        entry.mexRef = string2;
    }

    public String release(PartnerLinkInstance partnerLinkInstance, String string, String string2) {
        RequestIdTuple requestIdTuple;
        Entry entry;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"release", (Object[])new Object[]{"plinkInstance", partnerLinkInstance, "opName", string, "mexId", string2}));
        }
        if ((entry = this._byRid.get(requestIdTuple = new RequestIdTuple(partnerLinkInstance, string, string2))) == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("==release: RID " + requestIdTuple + " not found in " + this._byRid));
            }
            return null;
        }
        while (this._byChannel.values().remove(entry)) {
        }
        while (this._byRid.values().remove(entry)) {
        }
        return entry.mexRef;
    }

    public String[] releaseAll() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"releaseAll", null));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Entry entry : this._byChannel.values()) {
            if (entry.mexRef == null) continue;
            arrayList.add(entry.mexRef);
        }
        this._byChannel.values().clear();
        this._byRid.values().clear();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String toString() {
        return ObjectPrinter.toString((Object)this, (Object[])new Object[]{"byRid", this._byRid, "byChannel", this._byChannel});
    }

    private class Entry
    implements Serializable {
        private static final long serialVersionUID = -583743124656582887L;
        final String pickResponseChannel;
        final Selector[] selectors;
        String mexRef;

        private Entry(String string, Selector[] selectorArray) {
            this.pickResponseChannel = string;
            this.selectors = selectorArray;
        }

        public String toString() {
            return ObjectPrinter.toString((Object)this, (Object[])new Object[]{"pickResponseChannel", this.pickResponseChannel, "selectors", this.selectors, "mexRef", this.mexRef});
        }
    }

    private class RequestIdTuple
    implements Serializable {
        private static final long serialVersionUID = -1059389611839777482L;
        PartnerLinkInstance partnerLink;
        String opName;
        String mexId;

        private RequestIdTuple(PartnerLinkInstance partnerLinkInstance, String string, String string2) {
            this.partnerLink = partnerLinkInstance;
            this.opName = string;
            this.mexId = string2 == null ? "" : string2;
        }

        public int hashCode() {
            return this.partnerLink.hashCode() ^ this.opName.hashCode() ^ this.mexId.hashCode();
        }

        public boolean equals(Object object) {
            RequestIdTuple requestIdTuple = (RequestIdTuple)object;
            return requestIdTuple.partnerLink.equals(this.partnerLink) && requestIdTuple.opName.equals(this.opName) && requestIdTuple.mexId.equals(this.mexId);
        }

        public String toString() {
            return ObjectPrinter.toString((Object)this, (Object[])new Object[]{"partnerLink", this.partnerLink, "opName", this.opName, "mexId", this.mexId});
        }
    }
}

