/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store.hib;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.store.ConfStoreConnection;
import org.apache.ode.store.DeploymentUnitDAO;
import org.apache.ode.store.ProcessConfDAO;
import org.apache.ode.store.hib.DeploymentUnitDaoImpl;
import org.apache.ode.store.hib.ProcessConfDaoImpl;
import org.apache.ode.store.hib.VersionTrackerDAOImpl;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfStoreConnectionHib
implements ConfStoreConnection {
    private static final Log __log = LogFactory.getLog(ConfStoreConnectionHib.class);
    private Session _session;
    private Transaction _tx;
    static final ThreadLocal<Session> _current = new ThreadLocal();

    public ConfStoreConnectionHib(Session session) {
        this._session = session;
        _current.set(session);
    }

    public ProcessConfDAO getProcess(QName qName) {
        try {
            return (ProcessConfDaoImpl)this._session.get(ProcessConfDaoImpl.class, (Serializable)((Object)qName.toString()));
        }
        catch (HibernateException hibernateException) {
            __log.error((Object)"DbError", (Throwable)hibernateException);
            throw hibernateException;
        }
    }

    @Override
    public DeploymentUnitDAO createDeploymentUnit(String string) {
        DeploymentUnitDaoImpl deploymentUnitDaoImpl = new DeploymentUnitDaoImpl();
        deploymentUnitDaoImpl.setName(string);
        deploymentUnitDaoImpl.setDeployDate(new Date());
        this._session.save((Object)deploymentUnitDaoImpl);
        return deploymentUnitDaoImpl;
    }

    @Override
    public DeploymentUnitDAO getDeploymentUnit(String string) {
        try {
            DeploymentUnitDaoImpl deploymentUnitDaoImpl = (DeploymentUnitDaoImpl)this._session.get(DeploymentUnitDaoImpl.class, (Serializable)((Object)string));
            return deploymentUnitDaoImpl;
        }
        catch (HibernateException hibernateException) {
            __log.error((Object)"DbError", (Throwable)hibernateException);
            throw hibernateException;
        }
    }

    @Override
    public long getNextVersion() {
        VersionTrackerDAOImpl versionTrackerDAOImpl = (VersionTrackerDAOImpl)this._session.createQuery("from VersionTrackerDAOImpl v ").uniqueResult();
        if (versionTrackerDAOImpl == null) {
            return 1L;
        }
        return versionTrackerDAOImpl.getVersion() + 1L;
    }

    @Override
    public void setVersion(long l) {
        VersionTrackerDAOImpl versionTrackerDAOImpl = (VersionTrackerDAOImpl)this._session.createQuery("from VersionTrackerDAOImpl v ").uniqueResult();
        if (versionTrackerDAOImpl == null) {
            versionTrackerDAOImpl = new VersionTrackerDAOImpl();
            versionTrackerDAOImpl.setId(1);
        }
        versionTrackerDAOImpl.setVersion(l);
        this._session.save((Object)versionTrackerDAOImpl);
    }

    @Override
    public Collection<DeploymentUnitDAO> getDeploymentUnits() {
        Criteria criteria = this._session.createCriteria(DeploymentUnitDaoImpl.class);
        return criteria.list();
    }

    @Override
    public void close() {
        this._session.close();
    }

    @Override
    public void begin() {
        this._tx = this._session.beginTransaction();
    }

    @Override
    public void commit() {
        this._tx.commit();
    }

    @Override
    public void rollback() {
        this._tx.rollback();
    }
}

